package com.elitesland.sale2c.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.sale2c.Sale2cApplication;
import com.elitesland.sale2c.dto.Sale2cSoMpRpcDTO;
import com.elitesland.sale2c.dto.Sale2cSoRpcDTO;
import com.elitesland.sale2c.dto.syncPos.PSSale2cSoRpcDTO;
import com.elitesland.sale2c.param.Sale2cSoMpRpcParam;
import com.elitesland.sale2c.param.Sale2cSoRpcParam;
import com.elitesland.sale2c.param.Sale2cSoStockRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(name = Sale2cApplication.NAME, path = Sale2cApplication.PATH + Sale2cSoRpcService.PATH)
@Validated
public interface Sale2cSoRpcService {
    String PATH = "/sale2cSo";

    /**
     * 根据参数查询零售单
     *
     * @param param
     * @return
     */
    @PostMapping("/findSale2cSoByParam")
    ApiResult<List<Sale2cSoRpcDTO>> findSale2cSoByParam(@RequestBody Sale2cSoRpcParam param);

    /**
     * 扣库操作
     *
     * @param sale2cSoStockRpcParam
     * @return
     */
    @PostMapping("/stockOpt")
    ApiResult<Long> stockOperation(@RequestBody Sale2cSoStockRpcParam sale2cSoStockRpcParam);

    /**
     * 检查门店零售单
     *
     * @param paramVO
     * @return
     */
    @PostMapping("/check")
    ApiResult<Long> checkNewSoOrder(@RequestBody Sale2cSoRpcParam paramVO);

    /**
     *
     * @param param
     * @return
     */
    @PostMapping("/syncPosSale2cSo")
    ApiResult<String> syncPosSale2cSo(@RequestBody PSSale2cSoRpcDTO param);

    /**
     * 创建零售单
     * @param param
     * @return
     */
    @PostMapping("/createSale2cSo")
    ApiResult<String> createSale2cSo(@RequestBody PSSale2cSoRpcDTO param);

    /**
     * 根据参数查询零售单2
     *
     * @param param
     * @return
     */
    @PostMapping("/findSale2cSoByParamRefact")
    ApiResult<List<Sale2cSoRpcDTO>> findSale2cSoByParamRefact(@RequestBody Sale2cSoRpcParam param);


    @PostMapping("/rpc/sale2cSoMpCount")
    Sale2cSoMpRpcDTO sale2cSoMpCountQuery(@RequestBody Sale2cSoMpRpcParam paramVO);


}
