package com.elitesland.order.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Shadow
 * @since 2021-08-03 14:42
 */
@Data
@ApiModel(value = "SalDoDExamDTO", description = "验收时需修改发货单的信息")
public class SalDoDExamDTO implements Serializable {
    private static final long serialVersionUID = 9026876590604065339L;

    @ApiModelProperty("发货单明细ID")
    private Long doDId;

    @ApiModelProperty("本次验收数量")
    private BigDecimal examQty;

    @ApiModelProperty("本次验收金额")
    private BigDecimal examAmt;

    @ApiModelProperty("操作类型 提交：1  批准：2  拒绝：3")
    private Integer status;
}
