package com.elitesland.order.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author Shadow
 * @since 2021-07-09 14:42
 */
@Data
public class SalDoDRPCRespDTO implements Serializable {

    private static final long serialVersionUID = -5449572886003991436L;

    @ApiModelProperty("发货单明细ID")
    private Long id;

    @ApiModelProperty("订单号")
    private String relateDocNo;

    @ApiModelProperty("订单明细ID")
    private Long relateDocDid;

    @ApiModelProperty("订单主表ID")
    private Long relateDocId;

    @ApiModelProperty("订单类型")
    private String relateDocType;

    @ApiModelProperty("行号")
    private BigDecimal lineNo;

    @ApiModelProperty("发货单号")
    private String docNo;

    @ApiModelProperty("商品编号")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品规格")
    private String itemSpec;

    @ApiModelProperty("计量单位")
    private String uom;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("未含税单价")
    private BigDecimal netPrice;

    @ApiModelProperty("实发数量")
    private BigDecimal qty;

    @ApiModelProperty("取消数量")
    private BigDecimal cancelQty;

    @ApiModelProperty("已签收数量")
    private BigDecimal confirmQty;

    @ApiModelProperty("签收含税金额")
    private BigDecimal confirmAmt;

    @ApiModelProperty("签收不含税金额")
    private BigDecimal confirmNetAmt;

    @ApiModelProperty("发货时间")
    private LocalDateTime docTime;

    @ApiModelProperty("签收日期")
    private LocalDateTime confirmTime;

    @ApiModelProperty("订单数量")//sod
    private BigDecimal soQty;

    @ApiModelProperty("订单含税金额")//sod
    private BigDecimal soAmt;

    @ApiModelProperty("订单不含税金额")//sod
    private BigDecimal soNetAmt;

    @ApiModelProperty("订单税额")//sod
    private BigDecimal soTaxAmt;

    @ApiModelProperty("签收税额")
    private BigDecimal confirmTaxAmt;

    @ApiModelProperty("税率")//sod
    private BigDecimal soTaxRate;

    @ApiModelProperty("对账状态")
    private String soaStatus;

    @ApiModelProperty("验收状态")
    private String examStatus;

    @ApiModelProperty("商品品牌")
    private String itemBrand;

    @ApiModelProperty("税率编码")
    private String taxRateNo;

    @ApiModelProperty("待验收数量")
    private BigDecimal aeQty;

    @ApiModelProperty("验收中数量")
    private BigDecimal examingQty;

    @ApiModelProperty("已验收数量")
    private BigDecimal examedQty;

    @ApiModelProperty("币种Code")
    private String currCode;

    @ApiModelProperty("单据类型")
    private String docCls;

    @ApiModelProperty("合同id")
    private Long contractId;
    @ApiModelProperty("合同code")
    private String contractCode;
    @ApiModelProperty("合同名称")
    private String contractName;
}
