package com.elitesland.order.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author evin.dong
 * @Date 2021-06-30-1:32 下午
 * @Description 根据收款结算单号和金额，核对收款流水金额出参
 */
@Data
public class SalReceiptSerialCheckRespDTO implements Serializable {

    private static final long serialVersionUID = 6967148676373262744L;

    /**
     * 发货单编号
     */
    @ApiModelProperty("发货单编号")
    private String docNo;

    /**
     * 收款流水号集合
     */
    @ApiModelProperty("收款流水号集合")
    private List<String> receiptSerialList;

    /**
     * 是否成功
     */
    @ApiModelProperty("是否成功")
    private Boolean successFlag;

}
