package com.elitesland.order.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author evin.dong
 * @Date 2021-07-15-1:32 下午
 * @Description 订单收款结算细细表
 */
@Data
public class SalRevenueSettleddDTO implements Serializable {

    private static final long serialVersionUID = 3856852248344189066L;
    @ApiModelProperty(value = "唯一标识")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "收入结算单编号")
    private String revenueSettleDocno;

    @ApiModelProperty(value = "结算表明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long settleDId;

    @ApiModelProperty(value = "订单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long docId;

    @ApiModelProperty(value = "订单类别 [UDC]COM:DOC_CLS'")
    private String docCls;

    @ApiModelProperty(value = "结算类型")
    private String settleDocType;

    @ApiModelProperty(value = "结算类型名称")
    private String settleDocTypeName;

    @ApiModelProperty(value = "订单类型 [UDC]SAL:SO_TYPE")
    private String docType;

    @ApiModelProperty(value = "订单类型2 [UDC]SAL:SO_TYPE2")
    private String docType2;

    @ApiModelProperty(value = "订单编号")
    private String docNo;

    @ApiModelProperty(value = "下单渠道 [UDC]SAL:SO_SOURCE")
    private String soSource;

    @ApiModelProperty(value = "订单行ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long docDId;

    @ApiModelProperty(value = "行号")
    private BigDecimal lineNo;

    @ApiModelProperty(value = "订单行号")
    private BigDecimal soLineNo;

    @ApiModelProperty(value = "业务类型")
    private String busiType;

    @ApiModelProperty(value = "订单日期")
    private LocalDateTime docTime;

    @ApiModelProperty(value = "结算日期")
    private LocalDateTime settleDate;

    @ApiModelProperty(value = "父订单号")
    private String pno;

    @ApiModelProperty(value = "退货方式 [UDC]SAL:SO_RETURN_TYPE")
    private String returnType;

    @ApiModelProperty(value = "公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "公司编号")
    private String ouCode;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "收款账号id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long receiptAccId;

    @ApiModelProperty(value = "收款账号")
    private String receiptAccNo;

    @ApiModelProperty(value = "收款账号户名")
    private String receiptAccName;

    @ApiModelProperty(value = "收款公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long receiptOuId;

    @ApiModelProperty(value = "收款公司编号")
    private String receiptOuCode;

    @ApiModelProperty(value = "收款公司名称")
    private String receiptOuName;

    @ApiModelProperty(value = "BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty(value = "BU编号")
    private String buCode;

    @ApiModelProperty(value = "BU名称")
    private String buName;

    @ApiModelProperty(value = "客户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty(value = "客户编号")
    private String custCode;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "虚拟客户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long virtualCustId;

    @ApiModelProperty(value = "虚拟客户编号")
    private String virtualCustCode;

    @ApiModelProperty(value = "虚拟客户名称")
    private String virtualCustName;

    @ApiModelProperty(value = "客户组2")
    private String custGroup2;

    @ApiModelProperty(value = "结算组织类型")
    private String settleBuType;

    @ApiModelProperty(value = "组织类型")
    private String BuType;

    @ApiModelProperty(value = "币种编码审核人")
    private String currCode;

    @ApiModelProperty(value = "币种")
    private String currName;

    @ApiModelProperty(value = "业务员员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long agentEmpId;

    @ApiModelProperty("销售业务员用户id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long agentUserId;

    @ApiModelProperty(value = "业务员姓名")
    private String agentName;

    @ApiModelProperty("业务员编号")
    private String agentCode;

    @ApiModelProperty(value = "行类型")
    private String lineType;

    @ApiModelProperty(value = "商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty(value = "商品编号")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "商品类型")
    private String itemType;

    @ApiModelProperty(value = "商品名称2")
    private String itemName2;

    @ApiModelProperty(value = "商品规格")
    private String itemSpec;

    @ApiModelProperty(value = "商品品类")
    private String itemCat;

    @ApiModelProperty(value = "商品品类全路径名称")
    private List<String> itemCatName;

    @ApiModelProperty(value = "财务分类")
    private String finCat;

    @ApiModelProperty(value = "财务分类编码")
    private String finCatCode;

    @ApiModelProperty(value = "财务分类名称")
    private String finCatName;

    @ApiModelProperty(value = "审是否赠品核人")
    private Boolean ifGift;

    @ApiModelProperty(value = "计量单位")
    private String uom;

    @ApiModelProperty(value = "结算数量")
    private BigDecimal settleQty;

    @ApiModelProperty(value = "销售单价")
    private BigDecimal salePrice;

    @ApiModelProperty(value = "销售含税金额")
    private BigDecimal originAmt;

    @ApiModelProperty(value = "折扣含税金额")
    private BigDecimal discAmt;

    @ApiModelProperty(value = "优惠券金额")
    private BigDecimal couponAmt;

    @ApiModelProperty(value = "应收款金额")
    private BigDecimal apAmt;

    @ApiModelProperty(value = "购物卡金额")
    private BigDecimal cardAmt;

    @ApiModelProperty(value = "提货券金额")
    private BigDecimal giftAmt;

    @ApiModelProperty(value = "发放积分金额")
    private BigDecimal getpointAmt;

    @ApiModelProperty(value = "使用积分金额")
    private BigDecimal usepointAmt;

    @ApiModelProperty(value = "结算单价")
    private BigDecimal settlePrice;

    @ApiModelProperty(value = "结算含税金额")
    private BigDecimal settleAmt;

    @ApiModelProperty(value = "结算税额")
    private BigDecimal settleTax;

    @ApiModelProperty(value = "结算未税金额")
    private BigDecimal settleNetAmt;

    @ApiModelProperty(value = "税率编号")
    private String taxRateNo;

    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "收发货单ID 发生签收或验收的单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long doId;

    @ApiModelProperty(value = "收发货单明细ID 发生签收或验收的单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long doDId;

    @ApiModelProperty(value = "审核人")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long approvedUserId;

    @ApiModelProperty(value = "创建人")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    @ApiModelProperty(value = "创建时间")
    @JsonSerialize(using = ToStringSerializer.class)
    private LocalDateTime createTime;

    @ApiModelProperty(value = "销售订单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long soId;

    @ApiModelProperty(value = "销售订单明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long soDId;

}
