package com.elitesland.order.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * .
 *
 * @author evin.dong
 * @date 2021-06-16
 */
@ApiModel(description = "订单收款明细保存参数对象")
@Data
public class SalSoReceiptSaveDTO2 implements Serializable {

    private static final long serialVersionUID = -5011013960373235540L;

    @ApiModelProperty(value = "销售订单ID", required = true)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long soId;

    @ApiModelProperty(value = "销售订单号")
    private String soNo;

    @ApiModelProperty(value = "销售订单明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long soDId;

    @ApiModelProperty(value = "行号")
    private String soLineNo;

    @ApiModelProperty(value = "父订单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long psoId;

    @ApiModelProperty(value = "父订单编号")
    private String psoNo;

    @ApiModelProperty(value = "收款类型", required = true)
    private String receiptType;

    @ApiModelProperty(value = "付款方式 [UDC]COM:PAY_METHOD", required = true)
    private String receiptMethod;

    @ApiModelProperty(value = "收款金额", required = true)
    private BigDecimal receiptAmt;

    @ApiModelProperty(value = "收款税额")
    private BigDecimal receiptTax;

    @ApiModelProperty(value = "收款日期", required = true)
    private String receiptDate;

    @ApiModelProperty(value = "收款流水号")
    private String receiptSerial;

    @ApiModelProperty(value = "付款账号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long payAccId;

    @ApiModelProperty(value = "付款账号")
    private String payAccNo;

    @ApiModelProperty(value = "付款账号户名")
    private String payAccName;

    @ApiModelProperty(value = "关联单据类别")
    private String relateDocCls;

    @ApiModelProperty(value = "关联单据类型")
    private String relateDocType;

    @ApiModelProperty(value = "关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;

    @ApiModelProperty(value = "关联单据编号")
    private String relateDocNo;

    @ApiModelProperty(value = "关联单据明细ID")
    private Long relateDocDid;

    @ApiModelProperty(value = "关联单据行号")
    private String relateDocLineno;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "创建人ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    @ApiModelProperty(value = "创建时间")
    private String createTime;

    @ApiModelProperty(value = "审批时间")
    private String apprTime;

    @ApiModelProperty(value = "申请时间")
    private String applyTime;
    private Long receiptAccId;
    private String receiptAccNo;
    private String receiptAccName;
    private Long receiptOuId;
    private String receiptOuCode;
    private String receiptOuName;
}
