package com.elitesland.order.service;

import com.elitesland.order.Application;
import com.elitesland.order.param.SalSoDQueryDTO;
import com.elitesland.order.param.SalSoDRefundRespDTO;
import com.elitesland.order.param.SalSoDUpdateDTO;
import com.elitesland.order.param.SalSoReceiptSaveDTO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author Shadow
 * @since  2021/06/24 9:40
 */
@FeignClient(name = Application.NAME, path = Application.PATH + SalSoDUpdateRpcService.PATH)
@Validated
public interface SalSoDUpdateRpcService {

    String PATH = "/salSoDUpdateRpc";

    /**
     * 退货单查询
     * @param salSoDQueryDTO 查询参数
     * @return 退货单信息
     */
    @PostMapping("/queryRefund")
    ApiResult<PagingVO<SalSoDRefundRespDTO>> queryRefund(@RequestBody SalSoDQueryDTO salSoDQueryDTO);

    /**
     * 收款单提交/拒绝时，批量修改
     */
    @PostMapping("/updateWhenSubmitOrRefuse")
    ApiResult<String> updateWhenSubmitOrRefuse(@RequestBody List<SalSoDUpdateDTO> salSoDUpdateDTOS);

}
