package com.elitesland.order.service;

import com.elitesland.order.Application;
import com.elitesland.order.param.*;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

public interface SalSoReturnRpcService {

    /***
     * 数据需要按照订单中心退货单明细表的【供应商ID】来区分数据权限给供应商查看。
     * 供应商协同一件代退   分页列表查询
     * 成功返回 退货订单数据
     * @param searchParam
     */
    ApiResult<PagingVO<SalSoReturnRespDTO>> queryList(@NotNull(message = "查询参数不能为空") SalSoReturnQueryDTO searchParam);

    /***
     * 点击+ 展示订单对应的商品明细
     * 根据平台退货订单号查询对应退货单商品明细
     * 成功返回 退货订单数据
     * @param docNo 退货平台订单号
     * @param suppId 供应商id
     */
    ApiResult<List<SalSoItemReturnRespDTO>> queryItemByDocNo(@NotBlank(message = "退货单编号不能为空") String docNo, @NotNull(message = "供应商id不能为空") Long suppId);

    /***
     * 通过平台单号查询一件待退基本信息、客户收货信息、退货单明细
     * 根据退货单号查询销售退货订单基本信息、客户收货信息、退货单明细信息
     * 成功返回 销售退货订单基本信息、客户收货信息、退货单明细信息
     * @param docNo 查询入参退货单编号
     */
    ApiResult<SalSoDetailReturnRespDTO> querySalSoDetailByDocNo(@NotBlank(message = "退货单编号不能为空") String docNo, @NotNull(message = "供应商id不能为空") Long suppId);

    /***
     *B端商城退货订单
     */
    ApiResult<Object> toBRSOOrderSave(List<ToBRSalSoSaveDTO> toCRSalSoSaveList);

    /***
     * B端商城退货更新
     * @param toCSalSoSaveList
     * @return
     */
    public ApiResult<Long> toBsave(List<ToBRSalSoSaveDTO> toCSalSoSaveList);

    /***
     * B端商城同意退款
     * @param docNoList
     * @return
     */
    public ApiResult<Object> allowReturnMoney(List<String> docNoList);

    /***
     * B端商城拒绝退款
     * @param salSoSaveVO
     * @return
     */
    public ApiResult<Object> refuseReturnMoney(SalSoSaveDTO salSoSaveVO);


    public ApiResult<Object> toCRefuseReturnOrder(SalSoSaveDTO salSoSaveVO);

    /***
     * B端退款更新退货订单状态
     * @param toBUpdateSalRSoDTO
     * @return
     */
    public ApiResult<Object> updateReturnStatus(ToBUpdateSalRSoDTO toBUpdateSalRSoDTO);

    public ApiResult<Object> GetRsoIdAndDid(ToBGetSalRSoIdDTO toBGetSalRSoIdDTO);

    public ApiResult<Object> backReturnStatus(String rSoNo);
}
