package com.elitesland.order.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 协同数据查询(SalDoD)查询结果对象
 *
 * @author fred
 * @since 2021-06-02 11:32:18
 */

@Data
@ApiModel(value = "SalDoDAndSoRespDTO", description = "协同数据查询")
public class SalDoDAndSoRespDTO implements Serializable {

    private static final long serialVersionUID = -5075799789239602730L;
    /**
     * id(发货单明细id)
     * 发货单id
     * 店铺名称
     * 平台订单号
     * 订单编号
     * 订单行号
     * 订单创建时间
     * 商品
     * 商品品牌
     * 采购订单
     * 采购订单行号
     * 发货单号
     * 发货单行号
     * 发货时间
     * 单位
     * 采购订单数量
     * 已发货数量
     * 收货人
     * 收货手机
     * 收货人地址
     * 指定送货日期
     * 指定送货时间
     * 物流单号
     * 快递公司id
     * 地区
     * 发货单状态
     */
    /**
     * 记录唯一ID-发货单明细id
     */
    @ApiModelProperty("记录唯一ID-发货单明细id")
    private Long id;

    /**
     * 发货单ID
     */
    @ApiModelProperty("发货单ID")
    private Long doId;

    /**
     * 发货单编号
     */
    @ApiModelProperty("发货单编号")
    private String docNo;
    /**
     * 发货单日期
     */
    @ApiModelProperty("发货单日期")
    private LocalDate docDate;
    /**
     * 发货时间-发货单创建时间
     */
    @ApiModelProperty("发货时间")
    private LocalDateTime docTime;



    /**
     * 发货单行号
     */
    @ApiModelProperty(value = "发货单行号")
    private BigDecimal lineNo;
    /**
     * 订单行号
     */
    @ApiModelProperty(value = "订单行号")
    private BigDecimal relateDocLineno;
    /**
     * 单位-发货单商品单位
     */
    @ApiModelProperty("单位")
    private String uom;

    /**
     * 已发货数量
     */
    @ApiModelProperty("已发货数量")
    private BigDecimal shippedQty;


    /**
     * 收货国家
     */
    @ApiModelProperty("收货国家")
    private String recvCountry;
    /**
     * 收货省份
     */
    @ApiModelProperty("收货省份")
    private String recvProvince;
    /**
     * 收货省份Name
     */
    @ApiModelProperty("收货省份Name")
    private String recvProvinceName;
    /**
     * 城市
     */
    @ApiModelProperty("城市(编号/ID)")
    private String recvCity;
    @ApiModelProperty("城市名称")
    private String recvCityName;
    /**
     * 区县
     */
    @ApiModelProperty("区县(编号/ID)")
    private String recvCounty;
    @ApiModelProperty("区县名称")
    private String recvCountyName;

    /**
     * 收货地址拼接
     */
    @ApiModelProperty("收货地址拼接")
    private String recvAddress;

    /**
     * 收货详细地址
     */
    @ApiModelProperty("收货详细地址")
    private String recvDetailaddr;
    /**
     * 销售组织id
     */
    @ApiModelProperty("销售组织id")
    private Long buId;

    /**
     * 销售组织name
     */
    @ApiModelProperty("销售组织name")
    private String buName;


    /**
     * 销售单号-SAL_SO
     */
    @ApiModelProperty("销售单号")
    private String relateDocNo;

    /**
     * 平台订单号
     */
    @ApiModelProperty("平台订单号")
    private String docNo2;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("订单创建日期")
    private LocalDateTime createTime;
    /**
     * 商品编号
     */
    @ApiModelProperty("商品编号")
    private String itemCode;


    @ApiModelProperty("收货人")
    private String custContactName;

    /**
     * 收货人电话
     */
    @ApiModelProperty("收货人电话")
    private String custContactTel;
    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String itemBrand;



    @ApiModelProperty("指定送货日期")
    private LocalDateTime specifySendDate;
    @ApiModelProperty("指定送货时间")
    private LocalDateTime specifySendTime;




    /**
     * 销售区域 [UDC]SAL:SAL_REGION
     */
    @ApiModelProperty("销售区域 [UDC]SAL:SAL_REGION")
    private String saleRegion;

    /**
     * 物流公司ID
     */
    @ApiModelProperty("物流公司ID")
    private Long logisCarrierId;

    /**
     * 物流单号
     */
    @ApiModelProperty("物流单号")
    private String logisDocNo;
    /**
     * 发货单状态 [UDC]SAL:DO_STATUS
     */
    @ApiModelProperty("发货单状态 [UDC]SAL:DO_STATUS")
    private String docStatus;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

}
