package com.elitesland.order.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 项目公司集采-分子公司采购收货时，生成总部销售发货单参数-明细
 *
 * @author fred
 * @since 2021-06-07 11:32:19
 */

@Data
@ApiModel(value = "SalDoPurShipDetailReqDTO", description = "项目公司集采-分子公司采购收货时，生成总部销售发货单参数-明细")
public class SalDoPurShipDetailReqDTO implements Serializable {


    private static final long serialVersionUID = -4100589099635578355L;
    /**
     * 销售发货单 明细表	【商品】	来源于项目公司收货单明细表	Y
     * 	【数量】	来源于项目公司收货单明细表	Y
     * 	【单位】	来源于项目公司收货单明细表（总部采购订单单位）	Y
     * 	【项目公司采购收货单单号】	来源于项目公司的采购收货单号	Y
     * 	【项目公司采购收货单主表ID】	来源于项目公司的采购收货单主表ID	Y
     * 	【项目公司采购收货单行号】	来源于项目公司采购收货单明细行号	Y
     * 	【项目公司采购收货单明细ID】	来源于项目公司采购收货单明细ID	Y
     * 	【项目公司采购订单单号】	项目公司收货单明细行 的 采购订单单号
     * 	【项目公司采购订单主表ID】	项目公司收货单明细行 的 采购订单主表ID
     * 	【项目公司采购订单明细表行号】	项目公司收货单明细行 的 采购订单明细行行号
     * 	【项目公司采购订单明细表ID】	项目公司收货单明细行 的 采购订单明细行ID
     * 	【发货仓库】
     * 	【功能区】
     * 	【批次号】		
     */
    /**
     * 商品id
     */
    @ApiModelProperty("商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    /**
     * 要求发货数量-新建时的默认值是可发货数量， 可手填，不能大于可发货数量，不能<=0，保存后，再打开编辑时就带出上次保存的值，可手改。
     */
    @ApiModelProperty("要求发货数量")
    private BigDecimal demandQty;
    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String uom;
    /**
     * 采购订单主表ID
     */
    @ApiModelProperty("采购订单主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootDocId;
    /**
     * 采购订单单号
     */
    @ApiModelProperty("采购订单单号")
    private String rootDocNo;

    /**
     * 采购订单明细ID
     */
    @ApiModelProperty("采购订单明细ID ")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootDocDId;

    /**
     * 采购订单行号
     */
    @ApiModelProperty("采购订单行号 ")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootDocLineno;

    /**
     * 关联单据ID-销售订单
     */
    @ApiModelProperty("关联单据ID-销售订单")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;
    /**
     * 关联单据编号-销售订单
     */
    @ApiModelProperty("关联单据编号-销售订单")
    private String relateDocNo;
    /**
     * 关联单据明细ID-销售订单
     */
    @ApiModelProperty("关联单据明细ID-销售订单")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocDid;
    /**
     * 关联单据行号-销售订单
     */
    @ApiModelProperty("关联单据行号-销售订单")
    private BigDecimal relateDocLineno;

    /**
     * 关联单据2ID-采购收货单
     */
    @ApiModelProperty("关联单据2ID-采购收货单")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Id;
    /**
     * 关联单据2编号-采购收货单
     */
    @ApiModelProperty("关联单据2编号-采购收货单")
    private String relateDoc2No;
    /**
     * 关联单据2明细ID-采购收货单
     */
    @ApiModelProperty("关联单据2明细ID-采购收货单")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Did;
    /**
     * 关联单据2行号-采购收货单
     */
    @ApiModelProperty("关联单据2行号-采购收货单")
    private BigDecimal relateDoc2Lineno;

    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    /**
     * 限定2
     */
    @ApiModelProperty("限定2")
    private String deter2;
    /**
     * 批号
     */
    @ApiModelProperty("批号")
    private String lotNo;

}