package com.elitesland.order.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;


/**
 * 退货收货单(SalDoDO)保存参数(B端商城)
 *
 * @author dave
 * @since 2021-09-17 11:32:18
 */

@Data
@ApiModel(value = "SalDoReturnTOBSaveDTO", description = "退货收货单保存参数(B端商城)")
public class SalDoReturnTOBSaveDTO implements Serializable {

    private static final long serialVersionUID = 6905527785116042682L;
    /**
     * 退货订单号
     */
    @ApiModelProperty("退货收货单号")
    @NotBlank(message = "请输入退货订单编号！")
    private String docNo;

    /**
     * 物流公司编号
     */
    @ApiModelProperty("物流公司编号")
    private String logisCarrierNo;

    /**
     * 快递单编号
     */
    @ApiModelProperty("快递单编号")
    private String shiptranNo;

    /**
     * 营业厅退货标识
     */
    @ApiModelProperty("营业厅退货标识")
    private String flag;



    @ApiModelProperty("收货省份")
    private String recvProvince;

    @ApiModelProperty("城市(编号/ID)")
    private String recvCity;

    @ApiModelProperty("区县(编号/ID)")
    private String recvCounty;

    @ApiModelProperty("收货详细地址")
    private String recvDetailaddr;

    @ApiModelProperty("联系人")
    private String recvContactName;

    @ApiModelProperty("联系人电话")
    private String recvContactTel;
}