package com.elitesland.order.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author evin.dong
 * @Date 2021-06-30-1:32 下午
 * @Description 订单收款结算商品细表
 */
@Data
public class SalReceiptSettleDTO implements Serializable {

    private static final long serialVersionUID = -2065407868352570205L;
    @ApiModelProperty(value = "唯一标识")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("收款结算单号")
    private String docNo;

    @ApiModelProperty("结算类型")
    private String settleDocType;

    @ApiModelProperty("结算类型名称")
    private String settleDocTypeName;

    @ApiModelProperty("订单类型")
    private String docType2;

    @ApiModelProperty("收款日期")
    private LocalDateTime settleDate;

    @ApiModelProperty("下单渠道 [UDC]SAL:SO_SOURCE")
    private String soSource;

    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("BU编号")
    private String buCode;

    @ApiModelProperty("BU名称")
    private String buName;

    @ApiModelProperty("BU类型")
    private String buType;

    @ApiModelProperty("销售业务员员工id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long agentEmpId;

    @ApiModelProperty("销售业务员用户id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long agentUserId;

    @ApiModelProperty("业务员姓名")
    private String agentName;

    @ApiModelProperty("业务员编号")
    private String agentCode;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司")
    private String ouName;

    @ApiModelProperty("客户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("客户属性")
    private String custGroup2;

    @ApiModelProperty("是否入账")
    private String virtualFlag;

    @ApiModelProperty("是否预收")
    private String preFlag;

    @ApiModelProperty("单据状态")
    private String docStatus;

    @ApiModelProperty("创建人id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty(value = "收款账号id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long receiptAccId;

    @ApiModelProperty(value = "收款账号")
    private String receiptAccNo;

    @ApiModelProperty(value = "收款账号户名")
    private String receiptAccName;

    @ApiModelProperty(value = "收款公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long receiptOuId;

    @ApiModelProperty(value = "收款公司编号")
    private String receiptOuCode;

    @ApiModelProperty(value = "收款公司名称")
    private String receiptOuName;

    @ApiModelProperty(value = "关联结算单结算单号")
    private String relateDocNo;

    /**
     * 关联结算单主表ID
     */
    @ApiModelProperty(value = "关联结算单主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;

    @ApiModelProperty("收款商品明细")
    private List<SalReceiptSettleItemDTO> salReceiptSettleItemDTOS;

    @ApiModelProperty("收款结算明细")
    private List<SalReceiptSettleMethodDTO> salReceiptSettleMethodDTOS;

}
