package com.elitesland.order.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author maxin
 * @Date 2021-06-24-2:16 下午
 */
@Data
public class SalRevenueSettledDTO implements Serializable {

    private static final long serialVersionUID = -2286365502733409224L;
    @ApiModelProperty(value = "唯一标识")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "表头id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    @ApiModelProperty(value = "销售单编号")
    private String docNo;

    @ApiModelProperty(value = "退货方式")
    private String returnType;

    @ApiModelProperty(value = "商品分类")
    private String itemCat;

    @ApiModelProperty(value = "商品分类全路径名称")
    private List<String> itemCatName;

    @ApiModelProperty(value = "商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty(value = "计量单位")
    private String uom;

    @ApiModelProperty(value = "商品Name")
    private String itemName;

    @ApiModelProperty(value = "商品Code")
    private String itemCode;

    @ApiModelProperty(value = "财务分类")
    private String finCat;

    @ApiModelProperty(value = "财务分类名称")
    private String finCatName;

    @ApiModelProperty(value = "财务分类名称")
    private String finCatCode;

    @ApiModelProperty(value = "业务类型")
    private String busiType;

    @ApiModelProperty(value = "结算数量")
    private BigDecimal settleQty;

    @ApiModelProperty(value = "销售单价")
    private BigDecimal salePrice;

    @ApiModelProperty(value = "销售含税原金额")
    private BigDecimal originAmt;

    @ApiModelProperty(value = "折扣含税额")
    private BigDecimal discAmt;

    @ApiModelProperty(value = "优惠券金额")
    private BigDecimal couponAmt;

    @ApiModelProperty(value = "应收款金额")
    private BigDecimal apAmt;

    @ApiModelProperty(value = "购物卡金额")
    private BigDecimal cardAmt;

    @ApiModelProperty(value = "提货券金额")
    private BigDecimal giftAmt;

    @ApiModelProperty(value = "使用积分金额")
    private BigDecimal usepointAmt;

    @ApiModelProperty(value = "结算单价")
    private BigDecimal settlePrice;

    @ApiModelProperty(value = "结算含税金额")
    private BigDecimal settleAmt;

    @ApiModelProperty(value = "结算税额")
    private BigDecimal settleTax;

    @ApiModelProperty(value = "结算未税金额")
    private BigDecimal settleNetAmt;

    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "税率编号")
    private String taxRateNo;

    @ApiModelProperty(value = "发放积分金额")
    private BigDecimal getpointAmt;

    @ApiModelProperty(value = "行号")
    private Integer lineNo;

    @ApiModelProperty(value = "订单行号")
    private Integer soLineNo;

    @ApiModelProperty(value = "销售订单号")
    private String relateDocNo;

    @ApiModelProperty(value = "逆向销售订单号")
    private String relateDocNo2;

    @ApiModelProperty(value = "结算日期")
    private LocalDateTime settleDate;
}
