package com.elitesland.order.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(value = "SalSoStatusRespDTO", description = "订单状态查询-订单发货查询")
public class SalSoStatusRespDTO implements Serializable {

    private static final long serialVersionUID = -6509559942363356405L;

    /**
     * 销售订单id
     */
    @ApiModelProperty("销售订单id")
    private Long id;
    /**
     * 销售订单号
     */
    @ApiModelProperty("销售订单号")
    private String docNo;
    /**
     * 订单状态
     */
    @ApiModelProperty("订单状态")
    private String docStatus;
    /**
     * 订单创建日期
     */
    @ApiModelProperty("订单创建日期")
    private LocalDateTime createTime;

    /**
     * 物流数据集合
     */
    @ApiModelProperty("物流数据集合")
    private List<SalLogislogRespDTO> salLogislogRespDTOList;

}
