package com.elitesland.order.service;

import com.elitesland.order.Application;
import com.elitesland.order.param.*;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 发货单对外提供服务接口
 *
 * @author fred
 * @date 2021-05-31
 */
@FeignClient(name = Application.NAME, path = Application.PATH + SalDoRpcService.URI)
public interface SalDoRpcService {

    String URI =  "/salDo";

    /**
     * 通过快递单号、收货人、收货人手机、平台单据号（销售订单号）、单据创建日期查询，支持分页，根据平台单号+物流单号去重
     * @param salDoLogisQueryDTO 查询参数
     * @return 数据信息
     */
    @PostMapping("/querySalDoDLogis")
    ApiResult<PagingVO<SalDoLogisRespDTO>> querySalDoDLogis(@RequestBody SalDoLogisQueryDTO salDoLogisQueryDTO);


}
