package com.elitesland.order.service;

import com.elitesland.order.Application;
import com.elitesland.order.param.SalDoDExamDTO;
import com.elitesland.order.param.SalDoDQueryDTO;
import com.elitesland.order.param.SalDoDRPCRespDTO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.order.param.SalSoUpdateParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author Shadow
 * @since 2021-07-12 9:11
 */
@FeignClient(name = Application.NAME, path = Application.PATH + SalDoDRpcService.PATH)
@Validated
public interface SalDoDRpcService {

    String PATH = "/salDoDRpc";

    /**
     * 查询发货单
     *
     * @param salDoDQueryDTO 查询参数
     * @return 发货单
     */
    @PostMapping("/queryDodForInvoice")
    ApiResult<PagingVO<SalDoDRPCRespDTO>> queryDodForInvoice(@RequestBody SalDoDQueryDTO salDoDQueryDTO);
}
