package com.elitesland.order.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author jin
 * @since 2022-01-11
 */
@Data
@ApiModel(description = "数据检查跨库专用DTO")
public class CheckInvAndSaleRpcDTO implements Serializable {

    @ApiModelProperty("销售订单明细行ID")
    private Long sodId;
    @ApiModelProperty("发货订单明细ID")
    private Long dodId;
    @ApiModelProperty("销售订单编号")
    private String docNo;
    @ApiModelProperty("销售订单类型  udc：SO_TYPE")
    private String docType;
    @ApiModelProperty("销售订单行状态 UDC:SO_LINE_STATUS")
    private String lineStatus;
    @ApiModelProperty("配货状态 UDC: SO_ALLOC_STATUS")
    private String allocStatus;
    @ApiModelProperty("销售单订单状态 UDC:SO_STATUS")
    private String docStatus;
    @ApiModelProperty("销售订单行号")
    private BigDecimal lineNo;
    @ApiModelProperty("商品编号")
    private String itemCode;
    @ApiModelProperty("销售订单配货数量")
    private BigDecimal allocQty;
    @ApiModelProperty("订单总的已发货数量")
    private BigDecimal shippedQty;
    @ApiModelProperty("剩余锁定数量-以下俩字段的差")
    private BigDecimal sodStrartQty;
    private BigDecimal sodEndQty;
    @ApiModelProperty("单据类别")
    private String docCls;
}
