package com.elitesland.order.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author fred
 * 发货单明细的签收参数-多次签收
 */
@Data
@ApiModel(value = "SalDoDSignInfoDto", description = "发货单明细的签收参数-多次签收")
public class SalDoDSignInfoDto implements Serializable {

    private static final long serialVersionUID = 3862361352220948138L;
    /**
     * 发货明细单ID
     */
    @ApiModelProperty("发货明细单ID")
    private  Long id;

    /**
     * 签收数量
     */
    @ApiModelProperty("签收数量")
    private BigDecimal confirmQty;

    /**
     * 拒收数量
     */
    @ApiModelProperty("拒收数量")
    private BigDecimal rejectingQty;

}
