package com.elitesland.order.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 发货单一件代发查询
 *
 * @author fred
 * @since 2021-08-21 11:32:18
 */

@Data
@ApiModel(value = "SalDoForSuppRespDTO", description = "发货单一件代发查询")
public class SalDoForSuppRespDTO implements Serializable {

    private static final long serialVersionUID = 5735106933367838791L;
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 发货单编号
     */
    @ApiModelProperty("发货单编号")
    private String docNo;

    /**
     * 是否供应商代发 0:非一件代发;1:一件代发
     */
    @ApiModelProperty("是否供应商代发 0:非一件代发;1:一件代发")
    private String suppFlag;

}