package com.elitesland.order.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 项目公司集采-分子公司采购收货时，生成总部销售发货单-基本信息
 *
 * @author fred
 * @since 2021-07-09 11:32:19
 */

@Data
@ApiModel(value = "SalDoPurShipReqDTO", description = "项目公司集采-分子公司采购收货时，生成总部销售发货单-基本信息")
public class SalDoPurShipReqDTO implements Serializable {


    private static final long serialVersionUID = 6395372189268592181L;
    /**
     * 销售发货单 主表	【销售发货单号】	自动生成
     * 	【客户】	销售订单订单主表客户
     * 	【销售公司】	销售订单主表公司
     * 	【币别/汇率】	销售订单主表币别/汇率
     * 	【发货日期】	生成发货单的日期
     * 	【状态】	已签收
     * 	【仓库】	来源于总部采购订单仓库
     * 	【采购订单单号】	项目公司采购订单主表单号	Y
     * 	【采购订单主表ID】	项目公司采购订单主表ID	Y
     * 	【销售订单单号】	取当前收货单的项目公司采购订单生成的销售订单号
     * 	【销售订单主表ID】	取当前收货单的项目公司采购订单生成的销售订单主表ID
     *
     * 	备注：
     * 	1.【越库 生成DO单据时，DO的发货时间应取供应商发货单ss的时间 】
     */
    /**
     * 销售订单主表ID
     */
    @ApiModelProperty("销售订单主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 销售订单单号
     */
    @ApiModelProperty("销售订单单号")
    private String docNo;
    /**
     * 采购订单主表ID
     */
    @ApiModelProperty("采购订单主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootDocId;
    /**
     * 采购订单单号
     */
    @ApiModelProperty("采购订单单号")
    private String rootDocNo;
    /**
     * 关联单据2ID-采购收货单
     */
    @ApiModelProperty("关联单据2ID-采购收货单")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Id;
    /**
     * 关联单据2编号-采购收货单
     */
    @ApiModelProperty("关联单据2编号-采购收货单")
    private String relateDoc2No;
    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS-采购收货单
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS-采购收货单")
    private String relateDoc2Cls;
    /**
     * 关联单据2类型-采购收货单
     */
    @ApiModelProperty("关联单据2类型-采购收货单")
    private String relateDoc2Type;

    /**
     * 商品明细集合
     */
    @ApiModelProperty("商品明细集合")
    private List<SalDoPurShipDetailReqDTO> salDoPurShipDetailReqDTOList;

    /**
     * 发货时间
     */
    @ApiModelProperty("发货时间")
    private LocalDateTime docDate;

}