package com.elitesland.order.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 非一件代发-批量发货参数-基本信息
 *
 * @author fred
 * @since 2021-08-13 11:32:19
 */

@Data
@ApiModel(value = "SalDoShipAReqDTO", description = "非一件代发-批量发货参数-基本信息")
public class SalDoShipAReqDTO implements Serializable {


    private static final long serialVersionUID = 7250798688879350654L;
    /**
     * 单据编号
     */
    @ApiModelProperty("单据编号")
    private String docNo;
    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;
    /**
     * 发货单日期
     */
    @ApiModelProperty("发货单日期")
    private LocalDateTime docDate;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    private Long whId;
    /**
     * 物流公司名称
     */
    @ApiModelProperty("物流公司名称")
    private String logisCarrierName;
    /**
     * 物流单号
     */
    @ApiModelProperty("物流单号")
    private String logisDocNo;

    /**
     * 物流配送人
     */
    @ApiModelProperty("物流配送人")
    private String logisContactName;
    /**
     * 配送人联系方式
     */
    @ApiModelProperty("配送人联系方式")
    private String logisContactTel;

    /**
     * 商品明细集合
     */
    @ApiModelProperty("商品明细集合")
    private List<SalDoShipADetailReqDTO> salDoShipDetailReqDTOList;



}