package com.elitesland.order.service;

import com.elitesland.order.Application;
import com.elitesland.order.param.*;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 发货单对外提供服务接口
 *
 * @author fred
 * @date 2021-05-31
 */
public interface SalDoRpcService {

    /**
     * 更新OMS发货单生成状态参数
     *
     * @param salDoGenReqDTO 参数
     * @return 数据信息
     */
    ApiResult<Boolean> updateGenStatus(@NotNull(message = "参数值不能为空") SalDoGenReqDTO salDoGenReqDTO);

    /**
     * 一件代发生成采购订单(采购脱货单)
     *采购中心每天根据订单中心已签收的一件代发订单的发货单，合并生成一件代发采购单（按供应商+公司），并且后续用采购订单结算，不做收发货动作。
     * 采购中心每天根据订单中已签收的退货收货单，合并生成一件代发采购退货单（按供应商+公司），不做收发货动作。
     * 备注（复用）：
     * 订单结算	销售订单库存成本查询接口	B/C		提供销售发货单和退货收货单的查询
     * @param salDoReqDTO 查询参数
     * @return 数据信息
     */
    ApiResult<List<SalDoRespDTO>> queryForSupp(@NotNull(message = "参数值不能为空") SalDoReqDTO salDoReqDTO);
    /**
     * 库存成本计算
     *采购中心每天根据订单中心已签收的一件代发订单的发货单，合并生成一件代发采购单（按供应商+公司），并且后续用采购订单结算，不做收发货动作。
     * 采购中心每天根据订单中已签收的退货收货单，合并生成一件代发采购退货单（按供应商+公司），不做收发货动作。
     * 备注（复用）：
     * 订单结算	销售订单库存成本查询接口	B/C		提供销售发货单和退货收货单的查询
     * @param salDoReqDTO 查询参数
     * @return 数据信息
     */
    ApiResult<PagingVO<SalDoRespDTO>> queryForSuppPage(@NotNull(message = "参数值不能为空")SalDoReqPageDTO salDoReqDTO);
    /**
     * 按照发货单的维度显示 销售订单信息和采购订单信息。
     *单据间关系：订单中心发货单由订单中心销售订单作为数据源生成，
     * 采购中心采购订单由 订单中心发货单作为数据源生成。
     * @param salDoReqDTO 查询参数
     * @return 数据信息
     */
    ApiResult<PagingVO<SalDoDAndSoRespDTO>> querySalDoD(@NotNull(message = "参数值不能为空") SalDoQueryDTO salDoReqDTO);
    /**
     * 通过快递单号、收货人、收货人手机、平台单据号（销售订单号）、单据创建日期查询，支持分页，根据平台单号+物流单号去重
     * @param salDoLogisQueryDTO 查询参数
     * @return 数据信息
     */
    ApiResult<PagingVO<SalDoLogisRespDTO>> querySalDoDLogis(@NotNull(message = "参数值不能为空")SalDoLogisQueryDTO salDoLogisQueryDTO);
    /**
     * 供应商协同一件代发-批量发货
     * @param salDoShipReqDTOList 参数
     * @param methodType 0:非一件代发；1:一件代发，判断供应商；2:一件代发不判断供应商
     * @return 发货单生成结果-失败的订单号
     */
    ApiResult<List<String>> shipBySupp(@NotEmpty(message = "参数值不能为空") List<SalDoShipReqDTO> salDoShipReqDTOList, String methodType);
    /**
     * 采购中心-分子公司采购收货时，生成总部销售发货单
     * 提供 销售发货单生成接口，
     * 1、参数为总部SO的条目、收货数量，并关联分子公司GR的条目。
     * 2、生成的DO，ROOT为总部SO的ROOT，RELATE1为总部SO，RELATE2为分子公司GR。
     * 3、生成后要签收，调用手工签收的逻辑，但是因为供应链调用DO生成时，已经扣过库存，因此不需要调用扣库存逻辑。
     * @param salDoPurShipReqDTOS 参数
     * @return 发货单生成结果-失败的订单号
     */
    ApiResult<List<String>> shipByPur(@NotEmpty(message = "参数值不能为空") List<SalDoPurShipReqDTO> salDoPurShipReqDTOS, SalDoSignUserInfoDto salDoSignUserInfoDto);


    /**
     *
     * @param salDoSignReqDtoList 发货单明细信息
     * @param salDoSignUserInfoDto 签收人信息
     * @param fileCodes 上传文件信息 (可以为空)
     * @return
     */
    ApiResult<Boolean> bussinessDoSign(List<SalDoSignReqDto> salDoSignReqDtoList,SalDoSignUserInfoDto salDoSignUserInfoDto, List<String> fileCodes);
    /**
     * 非一件代发-批量发货
     * @param salDoShipReqDTOList 参数
     * @param methodType 0:非一件代发；1:一件代发，判断供应商；2:一件代发不判断供应商
     * @return 发货单生成结果-失败的订单号
     */
    ApiResult<List<String>> shipByImport(List<SalDoShipAReqDTO> salDoShipReqDTOList, String methodType);

    ApiResult<List<String>> shipByImport(List<SalDoShipAReqDTO> salDoShipReqDTOList, String methodType, Long recvWhId, String recvDeter2);
    /**
     * 一件代发查询
     * @param idList 查询参数
     * @return 数据信息
     */
    ApiResult<List<SalDoForSuppRespDTO>> queryForSuppByIdList(@NotNull(message = "参数值不能为空")List<Long> idList);
    /**
     * 一件代发查询
     * @param docNoList 查询参数
     * @return 数据信息
     */
    ApiResult<List<SalDoForSuppRespDTO>> queryForSuppByDocNoList(@NotNull(message = "参数值不能为空")List<String> docNoList);
    /**
     * 修改物流
     * @param param
     * @return
     */
    ApiResult<Boolean> updateLogis(@NotNull(message = "参数值不能为空")SalDoUpdateLogisDTO param);

    /**
     * B端商城的签收:
     * 根据订单编号查询发货单，对发货单状态为已发货 或已妥投的发货单执行签收操作
     *
     * @param salSoSignReqDto
     * @return
     */
    ApiResult<Boolean> signBySalSo(@NotNull(message = "参数值不能为空")SalSoSignReqDto salSoSignReqDto);
    /**
     * 订单状态查询-订单发货查询
     *供商城查询订单的发货状态，及发货单的物流信息
     * @param docNoList 查询参数
     * @return 数据信息
     */
    ApiResult<List<SalSoStatusRespDTO>> querySalSoStatus(@NotNull(message = "参数值不能为空")List<String> docNoList);
    /**
     * 集团内订单的签收参数-多次签收
     *
     * @param salDoMultiSignReqDto
     * @return
     */
    ApiResult<Boolean> multiSign(@NotNull(message = "参数值不能为空")SalDoMultiSignReqDto salDoMultiSignReqDto);

    /**
     * 查询发货单参与中台数据校验功能的数据-数据检查12 七、九、十
     */
    ApiResult<List<CheckInvAndPurRpcDTO>> selectCheckData(String docNo);

    /**
     * 禅道4209:yst-inv调用double接口实时查询逻辑---核对业务单据操作和移动记录信息
     */
    ApiResult<List<CheckInvAndPurRpcDTO>> selectCheckDataAndCreateTime(String docNo, LocalDateTime localDateTime);

    /**
     * 查询发货单参与中台数据校验功能的数据-数据检查12 八
     */
    ApiResult<List<CheckInvAndSaleRpcDTO>> selectCheckInvAndSale(String docNo);

    /**
     * 禅道4209:yst-inv调用double接口实时查询逻辑---核对销售订单锁定异常信息
     */
    ApiResult<List<CheckInvAndSaleRpcDTO>> selectCheckInvAndSaleAndCreateTime(String docNo, LocalDateTime localDateTime);

    ApiResult<Object> cancelSalSo(String docNo, String reason);

}
