package com.elitesland.order.service;

import com.elitesland.order.Application;
import com.elitesland.order.param.SalLotRespDTO;
import com.elitesland.order.param.SalLotSearchReqDTO;
import feign.Param;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(name = Application.NAME, path = SalLotRpcService.URI)
public interface SalLotRpcService {
    String URI =  Application.URI_PREFIX + "/salLot";

    @PostMapping("/salLot/save")
    Long save(@RequestBody SalLotRespDTO param);

    @DeleteMapping("/salLot/del")
    Long deleteLot(@Param("id") Long id);


    @PostMapping("/salLot/getLotByParam")
    List<SalLotRespDTO> getLotByParam(@RequestBody SalLotSearchReqDTO salLotSearchParam);


}
