package com.elitesland.order.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class ContractQtyDTO implements Serializable {
    /**
     * 合同条目id
     */
    @JsonSerialize(using = ToStringSerializer.class)
    private BigDecimal  relateDocLineno;
    /***
     * 已生成订单中条目数量
     */
    private BigDecimal haveOrderedQty;
    /**
     * 已生成订单中条目含税金额
     */
    private BigDecimal haveOrderedAmt;
}
