package com.elitesland.order.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author fred
 * 集团内订单的签收参数-多次签收
 */
@Data
@ApiModel(value = "SalDoMultiSignReqDto", description = "集团内订单的签收参数-多次签收")
public class SalRSoMultiSignReqDto implements Serializable {

    private static final long serialVersionUID = 2908439137244936125L;
    /**
     * 发货单id
     */
    @ApiModelProperty("发货单id")
    private  Long masId;
    @ApiModelProperty("销售退货单id")
    private  Long soId;

    /**
     * 发货单明细的签收参数
     */
    @ApiModelProperty("退货单明细的签收参数")
    private  List<SalRSoDSignInfoDto> salSoDSignInfoDtoList;

    /**
     * 签收人信息
     */
    @ApiModelProperty("签收人信息")
    private SalDoSignUserInfoDto salDoSignUserInfoDto;

    /**
     * 附件code 数组
     */
    @ApiModelProperty("附件code 数组")
    private List<String> fileCodes;


}
