package com.elitesland.order.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author maxin
 * @Date 2021-06-18-3:38 下午
 * @Description 生成结算单
 */
@Data
public class SalRevenueSettleDTO implements Serializable {
    private static final long serialVersionUID = -6759740910678379663L;

    @ApiModelProperty(value = "唯一标识")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("结算类型")
    private String settleDocType;

    @ApiModelProperty("结算类型名称")
    private String settleDocTypeName;

    @ApiModelProperty("虚拟用户编码")
    private String vmUserCode;

    @ApiModelProperty("订单类型2")
    private String docType2;

    @ApiModelProperty("订单编号")
    private String docNo;

    @ApiModelProperty("结算日期")
    private LocalDateTime settleDate;

    @ApiModelProperty("下单渠道 [UDC]SAL:SO_SOURCE")
    private String soSource;

    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("BU编号")
    private String buCode;

    @ApiModelProperty("BU名称")
    private String buName;

    @ApiModelProperty("BU类型")
    private String buType;

    @ApiModelProperty("BU类型名称")
    private String buTypeName;

    @ApiModelProperty("币种")
    private String currName;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司")
    private String ouName;

    @ApiModelProperty("客户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("客户属性")
    private String custGroup2;

    @ApiModelProperty("业务员员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long agentEmpId;

    @ApiModelProperty("销售业务员用户id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long agentUserId;

    @ApiModelProperty("业务员姓名")
    private String agentName;

    @ApiModelProperty("业务员编号")
    private String agentCode;

    @ApiModelProperty("结算总金额")
    private BigDecimal settleAmt;

    @ApiModelProperty("结算税额")
    private BigDecimal settleTax;

    @ApiModelProperty("创建人ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    @ApiModelProperty("审核人ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long approvedUserId;

    @ApiModelProperty("订单表明细")
    private List<SalRevenueSettledDTO> salSoDStatementDTOList;

}
