package com.elitesland.order.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@Data
public class SalSoReturnQueryDTO extends AbstractOrderQueryParam implements Serializable {

    private static final long serialVersionUID = 365066177601075339L;
    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @NotNull(message = "供应商ID不能为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    /**
     * 退货单编号
     */
    @ApiModelProperty("退货单编号")
    private String docNo;

    /**
     * 平台订单单据编号
     */
    @ApiModelProperty("平台订单单据编号")
    private String relateDocNo;

    /**
     * 平台订单单据编号List
     */
    @ApiModelProperty("平台订单单据编号List")
    private List<String> relateDocNos;

    /**
     * 平台订单单据id
     */
    @ApiModelProperty("平台订单单据id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;

    /**
     * 平台订单单据编号List
     */
    @ApiModelProperty("平台订单单据编号List")
    private List<Long> relateDocIds;

    /**
     * 商品编号
     */
    @ApiModelProperty("商品编号")
    private String itemCode;

    /**
     * 商品名称
     */
    @ApiModelProperty("商品名称")
    private String itemName;

    /**
     * 店铺id
     */
    @ApiModelProperty("店铺id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    /**
     * 店铺名称
     */
    @ApiModelProperty("店铺名称")
    private String buName;

    /**
     * 订单创建日期
     */
    @ApiModelProperty("订单创建开始日期")
    private String createTimeOrderStart;
    @ApiModelProperty("订单创建结束日期")
    private String createTimeOrderEnd;

    /**
     * 退货单创建日期
     */
    @ApiModelProperty("退货单创建开始日期")
    private String createTimeStart;
    @ApiModelProperty("退货单创建结束日期")
    private String createTimeEnd;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String recvContactName;

    /**
     * 客户手机
     */
    @ApiModelProperty("客户手机")
    private String recvContactTel;

    /**
     * 商品品牌
     */
    @ApiModelProperty("商品品牌")
    private String itemBrand;

    /**
     * 退货状态
     */
    @ApiModelProperty("退货状态")
    private String docStatus;

    /**
     * 退货方式
     */
    @ApiModelProperty("退货方式")
    private String returnType;

}
