package com.elitesland.order.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 一件代发生成采购订单查询参数-分页
 *
 * @author fred
 * @since 2021-08-03 11:32:19
 */
@Data
@ApiModel(value = "SalDoReqPageDTO", description = "一件代发生成采购订单查询参数-分页")
public class SalDoReqPageDTO extends AbstractOrderQueryParam implements Serializable {


    private static final long serialVersionUID = -6882619666331113702L;
    /**
     * 发货单日期开始
     */
    @ApiModelProperty("发货单日期开始")
//    @NotEmpty(message = "发货单日期不能为空")
    private String docDateStart;
    /**
     * 发货单日期开始
     */
    @ApiModelProperty("发货单日期结束")
//    @NotEmpty(message = "发货单日期不能为空")
    private String docDateEnd;
    /**
     * 发货时间开始
     */
    @ApiModelProperty("发货时间开始")
    private String docTimeStart;
    /**
     * 发货时间结束
     */
    @ApiModelProperty("发货时间结束")
    private String docTimeEnd;

    /**
     * 发货单状态 [UDC]SAL:DO_STATUS
     * CF表示已发货（只在发货单有），DONE表示已签收（发货单和收货单都有）
     */
    @ApiModelProperty("发货单状态 [UDC]SAL:DO_STATUS")
    private List<String> docStatus;

    /**
     * 单据类别 [UDC]COM:DOC_CLS
     * 传DO表示发货单，传RDO表示退货单
     */
    @ApiModelProperty("单据类别 [UDC]COM:DOC_CLS")
//    @NotBlank(message = "单据类别不能为空")
    private List<String> docCls;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    /**
     * 是否供应商代发
     * 一件代发标识（supp_flag ：1或0）
     */
    @ApiModelProperty("是否供应商代发")
    private String suppFlag;
    /**
     * 业务类型码
     * 8.销售出库	sal
     * 9.一件代发销售	onesal
     * 10.销售退货	salreturn
     * 11.一件代发销售退货	onesalreturn
     */
    @ApiModelProperty("业务类型码")
    private String bussiessConfigCode;


}