package com.elitesland.order.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Author: ryan.xu
 * @since 2023/12/7
 */
@Data
@ApiModel("销售退货入库回调明细入参")
public class SalDoReturnDRpcDTO implements Serializable {
    private static final long serialVersionUID = 8648884829365832607L;

    @ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty("主表ID")
    private Long masId;

    @ApiModelProperty("行号")
    private BigDecimal lineNo;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("实发数量")
    private BigDecimal qty;

    @ApiModelProperty("批号")
    private String lotNo;

    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;

    @ApiModelProperty("失效日期")
    private LocalDateTime expireDate;

    @ApiModelProperty("库存入库单明细id")
    private Long idoDid;

    @ApiModelProperty("退货订单ID")
    private Long relateDocId;

    @ApiModelProperty("退货订单单号")
    private String relateDocNo;

    @ApiModelProperty("退货订单明细ID")
    private Long relateDocDid;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("来源发货单明细id,无论是否复制的行，都有")
    private Long sourceDocDId;

    @ApiModelProperty("库存状态")
    private String limit1;

    @ApiModelProperty("生产厂家")
    private String manuFactory;
}
