package com.elitesland.order.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.order.Application;
import com.elitesland.order.param.SalDoReturnRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author ryan.xu
 * @since 2023-12-06
 */
@FeignClient(name = Application.NAME, path = Application.PATH + SalDoReturnDRpcService.PATH)
@Validated
public interface SalDoReturnDRpcService {

    String PATH = "/salRDod";

    /**
     * 从库存入库单同步销售退货入库单明细信息，至退货收货单明细表中，
     * 包括明细的新增/修改
     *
     * @param salDoReturnRpcDTO
     * @return
     */
    @PostMapping("/updateSalRDod")
    ApiResult<Long> updateSalRDod(@RequestBody SalDoReturnRpcDTO salDoReturnRpcDTO);

}
