package com.elitesland.order.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(description = "零售单分页查询参数")
public class RetailOrderPagingParam extends AbstractOrderQueryParam implements Serializable {

    @ApiModelProperty("id列表")
    private List<Long> ids;

    @ApiModelProperty("单据编号")
    private String docNo;
    @ApiModelProperty("来源单号")
    private String relateDocNo;
    @ApiModelProperty("外部订单号")
    private String outerNo;
    @ApiModelProperty("单据类别")
    private String docCls;

    @ApiModelProperty("单据类型")
    private String docType;
    @ApiModelProperty("单据状态 [UDC]SAL:SO_STATUS/RSO_STATUS")
    private String docStatus;
    @ApiModelProperty("扣库状态")
    private String deductStockStatus;

    @ApiModelProperty("来源渠道")
    private String orderSource;
    @ApiModelProperty("经营性质")
    private String storeType2;
    @ApiModelProperty("门店ID")
    private Long storeId;
    @ApiModelProperty("公司ID")
    private Long ouId;
    @ApiModelProperty("来源系统")
    private String sourceSystem;
    @ApiModelProperty("记账日期-开始")
    private LocalDateTime accountTimeFrom;
    @ApiModelProperty("记账日期-结束")
    private LocalDateTime accountTimeTo;
    @ApiModelProperty("业务日期-开始")
    private LocalDateTime busTimeFrom;
    @ApiModelProperty("业务日期-结束")
    private LocalDateTime busTimeTo;
    @ApiModelProperty("创建日期-开始")
    private LocalDateTime createTimeFrom;
    @ApiModelProperty("创建日期-结束")
    private LocalDateTime createTimeTo;
}