package com.elitesland.order.param;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(value = "SalSoSaveVO", description = "销售订单表")
public class SalSoSaveRpcParam extends CustomFieldBaseModelVo implements Serializable {
    @java.io.Serial
    private static final long serialVersionUID = -8056327031848758177L;

    @ApiModelProperty("主客户编号")
    private String preCustCode;
    @ApiModelProperty("主客户名称")
    private String preCustName;
    @ApiModelProperty("客户渠道")
    private String saleChannel;

    private Long secBuId;
    private String docLevel;
    private Long secUserId;
    private Long secOuId;
    private List<String> salSoIds;

    @ApiModelProperty("是否自动审核过")
    private Boolean autoCheckFlag;

    @ApiModelProperty("公司ID")
    //@NotNull(message = "公司id不能为空")
    private Long ouId;
    @ApiModelProperty("公司编码")
    private String ouCode;
    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("组织ID")
    private Long buId;
    @ApiModelProperty("组织编码")
    private String buCode;
    @ApiModelProperty("组织名称")
    private String buName;

    @ApiModelProperty("BUID2")
    private Long buId2;

    @ApiModelProperty("业务员员工ID")
    //@NotNull(message = "业务员员工ID不能为空")
    private Long agentEmpId;
    @ApiModelProperty("业务员员工名称")
    private String agentName;
    @ApiModelProperty("业务员员工编号")
    private String agentCode;

    @ApiModelProperty("导购员ID")
    private Long agentEmpId2;
    @ApiModelProperty("导购员编号")
    private String agentCode2;
    @ApiModelProperty("导购员名称")
    private String agentName2;

    @ApiModelProperty("应支付金额")
    private BigDecimal apAmt;
    @ApiModelProperty("已支付金额")
    private BigDecimal payedAmt;
    @ApiModelProperty("未结金额")
    private BigDecimal openAmt;

    @ApiModelProperty("单据类别 [UDC]COM:DOC_CLS")
    private String docCls;

    @ApiModelProperty("单据编号")
    private String docNo;
    @ApiModelProperty("单据编号2")
    private String docNo2;

    @ApiModelProperty("单据类型 [UDC]SAL:SO_TYPE")
    //NotBlank(message = "单据类型不能为空")
    private String docType;

    @ApiModelProperty("单据类型2")
    private String docType2;

    @ApiModelProperty("单据类型3")
    private String docType3;

    @ApiModelProperty("单据状态 [UDC]SAL:SO_STATUS/RSO_STATUS")
    private String docStatus;

    @ApiModelProperty("单据状态2")
    private String docStatus2;

    @ApiModelProperty("审批状态 [UDC]COM:APPR_STATUS")
    private ProcInstStatus apprStatus;
    @ApiModelProperty("审批时间")
    private LocalDateTime apprTime;
    @ApiModelProperty("审批人ID")
    private Long apprUserId;
    @ApiModelProperty("审批意见")
    private String apprComment;

    @ApiModelProperty("订单日期")
    private LocalDateTime docTime;

    @ApiModelProperty("销售场景")
    //@NotBlank(message = "销售场景不能为空")
    private String soScene;
    @ApiModelProperty("销售场景编号")
    private String sceneCode;

    @ApiModelProperty("客户订单号码")
    private String custSoNo;

    @ApiModelProperty("客户订单日期")
    private LocalDateTime custSoDate;

    @ApiModelProperty(value = "经销商类型,[UDC]yst-sale:CUST_TYPE")
    private String custType;
    private String custTypeName;
    @ApiModelProperty("客户ID 售至")
    private Long custId;
    @ApiModelProperty("客户名称")
    private String custName;
    @ApiModelProperty("客户编号")
    private String custCode;
    @ApiModelProperty("客户联系人 客户跟单人员")
    private String custContactName;
    @ApiModelProperty("客户联系人电话")
    private String custContactTel;
    @ApiModelProperty("客户联系人邮箱")
    private String custContactEmail;

    @ApiModelProperty("暂挂原因码 [UDC]SAL:SO_HOLD_REASON")
    private String holdReasonCode;
    @ApiModelProperty("暂挂时间")
    private LocalDateTime holdTime;
    @ApiModelProperty("暂挂描述")
    private String holdReasonDesc;

    @ApiModelProperty("失效日期")
    private LocalDateTime invalidDate;

    @ApiModelProperty("越库标识")
    private String crosswhFlag;

    //@NotBlank(message = "下单渠道不能为空")
    @ApiModelProperty("下单渠道")
    private String soSource;
    @ApiModelProperty("下单渠道2")
    private String soSource2;

    @ApiModelProperty("销售区域 [UDC]SAL:SAL_REGION")
    private String saleRegion;

    @ApiModelProperty("配送区域")
    private String deliverRegion;

    @ApiModelProperty("客户渠道")
    private String custChannel;

    @ApiModelProperty("开票至客户ID")
    private Long billtoCustId;

    @ApiModelProperty("销售组")
    private String saleGroup;

    @ApiModelProperty("本币币种")
    private String homeCurr;

    @ApiModelProperty("币种")
    private String currCode;
    private String currName;

    @ApiModelProperty("汇率")
    private BigDecimal currRate;

    @ApiModelProperty("是否含税")
    private String taxInclFlag;

    @ApiModelProperty("税码")
    private String taxCode;

    @ApiModelProperty("税率编号")
    private String taxRateNo;
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("含税总金额")
    private BigDecimal amt;
    @ApiModelProperty("未税总金额")
    private BigDecimal netAmt;
    @ApiModelProperty("未税原总金额")
    private BigDecimal oringNetAmt;

    @ApiModelProperty("未税原金额")
    private BigDecimal orignNetAmt;
    @ApiModelProperty("含税原金额")
    private BigDecimal oringAmt;

    @ApiModelProperty("未税运费金额")
    private BigDecimal freightFee;

    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;
    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;

    @ApiModelProperty("总数量")
    private BigDecimal qty;
    @ApiModelProperty("数量单位")
    private String qtyUom;

    @ApiModelProperty("总数量2")
    private BigDecimal qty2;
    @ApiModelProperty("数量2单位")
    private String qty2Uom;

    @ApiModelProperty("净重")
    private BigDecimal netWeight;
    @ApiModelProperty("毛重")
    private BigDecimal grossWeight;
    @ApiModelProperty("重量单位")
    private String weightUom;

    @ApiModelProperty("体积")
    private BigDecimal volume;
    @ApiModelProperty("体积单位")
    private String volumeUom;

    @ApiModelProperty("付款条款")
    private String paymentTerm;

    @ApiModelProperty("装箱要求 [UDC]COM:PACK_DEMAND")
    private String packDemand;

    @ApiModelProperty("支付状态")
    private String payStatus;
    @ApiModelProperty("支付时间")
    private LocalDateTime payTime;
    @ApiModelProperty("支付交易ID")
    private Long payTransId;
    @ApiModelProperty("付款方式/结算方式 [UDC]COM:PAY_METHOD")
    private String payMethod;

    @ApiModelProperty("物流状态")
    private String logisStatus;

    @ApiModelProperty("运输方式 [UDC]COM:TP_TYPE")
    private String transType;

    @ApiModelProperty("承运商")
    private String carrier;

    @ApiModelProperty("从地点")
    private String fromLoc;
    @ApiModelProperty("到地点")
    private String toLoc;

    @ApiModelProperty("仓库ID")
    private Long whId;
    private String whCode;
    private String whName;
    @ApiModelProperty("限定1")
    private String deter1;
    @ApiModelProperty("限定2")
    private String deter2;
    @ApiModelProperty("库位")
    private String whLoc;
    @ApiModelProperty("货位")
    private String whPosi;

    @ApiModelProperty("要求日期")
    private LocalDateTime demandDate;

    @ApiModelProperty("计划出库日期")
    private LocalDateTime planShipDate;

    @ApiModelProperty("承诺交货日期")
    private LocalDateTime promiseDeliverDate;

    @ApiModelProperty("出库确认时间")
    private LocalDateTime shipConfirmTime;

    @ApiModelProperty("确认收货时间")
    private LocalDateTime recvConfirmTime;

    @ApiModelProperty("交货指令1")
    private String deliverInstruct;
    @ApiModelProperty("交货指令2")
    private String deliverInstruc2;

    @ApiModelProperty("配送方式 [UDC]SAL:SO_DELIVER_METHOD")
    private String deliverMethod;

    @ApiModelProperty("仓库ID")
    private Long recvWhId;
    @ApiModelProperty("收方限定1")
    private String recvDeter1;
    @ApiModelProperty("收方限定2")
    private String recvDeter2;

    @ApiModelProperty("收货地址号")
    private Long recvAddrNo;
    @ApiModelProperty("收货联系人")
    private String recvContactName;
    @ApiModelProperty("收货联系电话")
    private String recvContactTel;
    @ApiModelProperty("收货联系人邮箱")
    private String recvContactEmail;
    @ApiModelProperty("收货国家")
    private String recvCountry;
    @ApiModelProperty("收货省")
    private String recvProvince;
    @ApiModelProperty("收货市")
    private String recvCity;
    @ApiModelProperty("收货区县")
    private String recvCounty;
    @ApiModelProperty("收货乡镇街道")
    private String recvStreet;
    @ApiModelProperty("收货详细地址")
    private String recvDetailaddr;

    @ApiModelProperty("退货原因码 [UDC]SAL:SO_RETURN_REASON")
    private String returnReasonCode;

    @ApiModelProperty("退货状态")
    private String returnStatus;

    @ApiModelProperty("退货申请时间")
    private LocalDateTime returnApplyTime;

    @ApiModelProperty("退货批准时间")
    private LocalDateTime returnApprTime;

    @ApiModelProperty("未税折扣金额")
    private BigDecimal discNetAmt;

    @ApiModelProperty("关单原因码 [UDC]SAL:SO_CLOSE_REASON")
    private String closeReasonCode;

    @ApiModelProperty("关单人ID")
    private Long closeUserId;

    @ApiModelProperty("含税发运总金额")
    private BigDecimal shippedAmt;

    @ApiModelProperty("未税发运总金额")
    private BigDecimal shippedNetAmt;

    @ApiModelProperty("合同编号")
    private String contractCode;
    @ApiModelProperty("合同id")
    private String contractId;
    @ApiModelProperty("合同名称")
    private String contractName;

    @ApiModelProperty("含税退货总金额")
    private BigDecimal returnAmt;
    @ApiModelProperty("未税退货总金额")
    private BigDecimal returnNetAmt;

    @ApiModelProperty("取消时间")
    private LocalDateTime cancelTime;
    @ApiModelProperty("取消原因 [UDC]SAL:SO_CANCEL_REASON")
    private String cancelReason;
    @ApiModelProperty("取消用户ID")
    private Long cancelUserId;

    @ApiModelProperty("退款状态")
    private String refundStatus;
    @ApiModelProperty("退款时间")
    private LocalDateTime refundTime;
    @ApiModelProperty("退款金额")
    private BigDecimal refundAmt;

    @ApiModelProperty("折扣率")
    private BigDecimal discRatio;
    @ApiModelProperty("含税折扣金额")
    private BigDecimal discAmt;
    @ApiModelProperty("折扣描述")
    private String discDesc;

    @ApiModelProperty("发票状态")
    private String invStatus;
    @ApiModelProperty("发票日期")
    private String invDate;
    @ApiModelProperty("开票类型")
    private String invType;

    @ApiModelProperty("供应商ID 用于代发")
    private Long suppId;

    @ApiModelProperty("根ID")
    private Long rootId;

    @ApiModelProperty("关联单据类别 来源采购订单等。[UDC]COM:DOC_CLS")
    private String relateDocCls;
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;

    @ApiModelProperty("来源单据类别 来源采购订单等。[UDC]COM:DOC_CLS")
    private String rootDocCls;
    @ApiModelProperty("来源单据类型")
    private String rootDocType;
    @ApiModelProperty("来源单据ID")
    private Long rootDocId;
    @ApiModelProperty("来源单据编号")
    private String rootDocNo;

    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    private String relateDoc2Cls;
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;

    @ApiModelProperty("关联ID")
    private Long relateId;
    @ApiModelProperty("关联编号")
    private String relateNo;

    @ApiModelProperty("关联编号2")
    private String relateNo2;

    @ApiModelProperty("关联2ID")
    private Long relate2Id;
    @ApiModelProperty("关联2编号")
    private String relate2No;

    @ApiModelProperty("外部单据公司")
    private String outerOu;
    @ApiModelProperty("外部单据类型")
    private String outerType;
    @ApiModelProperty("外部单据编号")
    private String outerNo;

    @ApiModelProperty("备注2")
    private String remark2;

    @ApiModelProperty("确认时间")
    private LocalDateTime confirmedTime;

    @ApiModelProperty("是否走接口")
    private String intfFlag;

    @ApiModelProperty("附件code 数组")
    private List<String> fileCodes;

    @ApiModelProperty("订单明细")
    private List<SalSoDSaveRpcParam> salSoDSaveVOList;

    @ApiModelProperty("制单人电话")
    private String creatorTel;

    @ApiModelProperty("销售订单行价格明细")
    private List<SalSoPriceRpcParam> salSoPriceSaveVOS;

    @ApiModelProperty("排期类型")
    private String scheduleType;

    @ApiModelProperty("发货单明细关联销售订单明细行号集合")
    private List<BigDecimal> relateDocLineNos;

    @ApiModelProperty("退货方式")
    @SysCode(sys = "yst-order", mod = "SO_RETURN_TYPE")
    private String returnType;
    @ApiModelProperty("退货方式 name")
    private String returnTypeName;

    @ApiModelProperty("代下单类型[UDC]SAL:AGENT_TYPE")
    private String agentType;

    @ApiModelProperty("拒绝退货退款原因")
    private String reason;

    @ApiModelProperty("预约时间段")
    private String appointTime;

    @ApiModelProperty("生成类型")
    private String genType;

    @ApiModelProperty("是否可发货")
    private Boolean isCanDeliver;

    @ApiModelProperty("交货清单")
    private List<SalDeliveryListSaveRpcParam> deliveryList;
    @ApiModelProperty("交货清单附件编码")
    private String salDeliveryFileCode;

    @ApiModelProperty("项目编码")
    private String projectCode;
    @ApiModelProperty("项目名称")
    private String projectName;

    @ApiModelProperty(value = "销售模式,[UDC]yst-sale:SALE_MODE")
    @SysCode(sys = "yst-sale", mod = "SALE_MODE")
    private String saleMode;
    private String saleModeName;

    @ApiModelProperty(value = "订单来源,[UDC]yst-order:ORDER_SOURCE")
    private String orderSource;
    private String orderSourceName;

    @ApiModelProperty(value = "付款条件,[UDC]yst-order:PAYMENT_TERMS")
    private String paymentTerms;
    private String paymentTermsName;

    @ApiModelProperty(value = "起效日期")
    private LocalDateTime effectiveDate;

    @ApiModelProperty(value = "起效日期类型,[UDC]yst-fin:AGREEMENT_EFFECTIVE_DATE_TYPE")
    private String effectiveDateType;
    private String effectiveDateTypeName;

    @ApiModelProperty(value = "账期天数")
    private Integer creditPeriod;

    @ApiModelProperty(value = "来源单号")
    private String orderSourceNo;
    @ApiModelProperty("是否需要验收（0-否、1-是）")
    private Integer acceptance;


    @ApiModelProperty("客商ID")
    Long enterpriseId;
    @ApiModelProperty("客商编码")
    String enterpriseCode;
    @ApiModelProperty("客商名称")
    String enterpriseName;
    @ApiModelProperty("客商客商类型")
    @SysCode(
            sys = "yst-purc",
            mod = "ENTERPRISE_TYPE"
    )
    private String enterpriseType;
    @ApiModelProperty("客商客商类型名称")
    private String enterpriseTypeName;

    @ApiModelProperty("召回单号")
    private String recallDocNo;
    @ApiModelProperty("召回单号ID")
    private Long recallId;
    @ApiModelProperty("换货销售单号")
    private String exchangeDocNo;
    @ApiModelProperty("换货销售ID")
    private Long exchangeId;
}
