package com.elitesland.order.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.order.Application;
import com.elitesland.order.param.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(name = Application.NAME, path = Application.PATH + RetailOrderRpcService.PATH)
@Validated
public interface RetailOrderRpcService {
    String PATH = "/retailOrderRpc";

    /**
     * 零售单-保存
     */
    @PostMapping("/save")
    ApiResult<Long> save(@RequestBody RetailOrderSaveVO saveVO);

}
