package com.elitesland.order.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Shadow
 * @since 2021-07-12 16:42
 */
@Data
public class SalSoDRefundRespDTO implements Serializable {

    private static final long serialVersionUID = 4510471662553227231L;

    @ApiModelProperty("退货订单号")//so
    private String docNo;

    @ApiModelProperty("退货订单类型")//so
    private String docType;

    @ApiModelProperty("退货订单行ID")
    private Long sodId;

    @ApiModelProperty("销售公司")
    private Long ouId;
    private String ouName;

    @ApiModelProperty("行号")
    private BigDecimal lineNo;

    @ApiModelProperty("税额")
    private BigDecimal soTaxAmt;
    @ApiModelProperty("税率编号")
    private String soTaxRateNo;
    @ApiModelProperty("税率")
    private BigDecimal soTaxRate;
    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("商品编号")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品品牌")
    private String itemBrand;

    @ApiModelProperty("商品规格")
    private String itemSpec;

    @ApiModelProperty("计量单位")
    private String uom;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("未含税单价")
    private BigDecimal netPrice;

    @ApiModelProperty("申请退货数量")
    private BigDecimal qty;

    @ApiModelProperty("实际退货数量")
    private BigDecimal confirmQty;

    @ApiModelProperty("申请退货金额(含税)")
    private BigDecimal amt;
    @ApiModelProperty("申请退货金额(未税)")
    private BigDecimal netAmt;

    @ApiModelProperty("实际退货金额")
    private BigDecimal confirmAmt;

    @ApiModelProperty("批准退款金额")
    private BigDecimal refundAmt;

    @ApiModelProperty("待退款金额")
    private BigDecimal openAmt;

    @ApiModelProperty("退款中金额")
    private BigDecimal payingAmt;

    @ApiModelProperty("已退款金额")
    private BigDecimal payedAmt;

    @ApiModelProperty("单据类型")
    private String docCls;

    @ApiModelProperty("合同id")
    private Long contractId;
    @ApiModelProperty("合同code")
    private String contractCode;
    @ApiModelProperty("合同名称")
    private String contractName;
}
