package com.elitesland.order.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author evin.dong
 * @Date 2021-06-30-1:32 下午
 * @Description 订单收款结算商品细表
 */
@Data
public class SalReceiptSettleMethodDTO implements Serializable {

    private static final long serialVersionUID = -481491455383347990L;
    @ApiModelProperty(value = "唯一标识")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "表头id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    @ApiModelProperty(value = "收款类型 [UDC]COM:RECEIPT_TYPE")
    private String receiptType;
    private String receiptTypeName;

    @ApiModelProperty(value = "付款方式 [UDC]COM:PAY_METHOD")
    private String receiptMethod;
    private String receiptMethodName;

    @ApiModelProperty(value = "收款金额")
    private BigDecimal receiptAmt;

    @ApiModelProperty(value = "收款日期")
    private LocalDateTime receiptDate;

    @ApiModelProperty(value = "收款流水号")
    private String receiptSerial;

    @ApiModelProperty(value = "付款账号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long payAccId;

    @ApiModelProperty(value = "付款账号")
    private String payAccNo;

    @ApiModelProperty(value = "付款账号户名")
    private String payAccName;

    @ApiModelProperty(value = "付款账ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long receiptAccId;

    @ApiModelProperty(value = "收款账号")
    private String receiptAccNo;

    @ApiModelProperty(value = "合同号")
    private String contractNo;

    @ApiModelProperty(value = "批次号ID从")
    private Long intfBatchFrom;

    @ApiModelProperty(value = "批次号ID到")
    private Long intfBatchTo;

    @ApiModelProperty(value = "订单编号")
    private String docNo;

    @ApiModelProperty(value = "行号")
    private Integer lineNo;

    @ApiModelProperty(value = "订单行号")
    private Integer soLineNo;
}
