package com.elitesland.order.service;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.order.Application;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Set;

/**
 * 订单场景.
 *
 * @author Kaiser（wang shao）
 * @date 2025/11/7 周五
 */
@Api(tags = "订单场景")
@FeignClient(name = Application.NAME, path = SalSceneRpcService.URI)
public interface SalSceneRpcService {
    String URI = Application.URI_PREFIX + "/scene";

    @ApiOperation(value = "根据场景ID获取编码和名称")
    @PostMapping(value = "/listIdCodeName")
    ApiResult<List<IdCodeNameParam>> listIdCodeName(@RequestBody Set<Long> ids);

    @ApiOperation(value = "根据编码获取场景ID和名称")
    @PostMapping(value = "/listIdCodeNameByCode")
    ApiResult<List<IdCodeNameParam>> listIdCodeNameByCode(@RequestBody Set<String> codes);
}
