package com.elitesland.order.param;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class SalSoDetailReturnRespDTO implements Serializable {
    private static final long serialVersionUID = -6759740910978379663L;

    /**
     * 退货单ID
     */
    @ApiModelProperty("退货单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 退货订单号
     */
    @ApiModelProperty("退货订单号")
    private String docNo;

    /**
     * 退货单创建日期
     */
    @ApiModelProperty("退货单创建日期")
    private LocalDateTime createTime;

    /**
     * 平台订单编号
     */
    @ApiModelProperty("平台订单编号")
    private String relateDocNo;

    /**
     * 订单创建日期
     */
    @ApiModelProperty("订单创建日期")
    private LocalDateTime createTimeOrder;

    /**
     * 退货状态
     */
    @ApiModelProperty("退货状态")
    private String docStatus;

    /**
     * 退货方式
     */
    @ApiModelProperty("退货方式")
    @SysCode(sys = "yst-order", mod = "SO_RETURN_TYPE")
    private String returnType;
    @ApiModelProperty("退货方式 name")
    private String returnTypeName;

    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    @ApiModelProperty("供应商编号")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;


    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String recvContactName;

    /**
     * 客户手机
     */
    @ApiModelProperty("客户手机")
    private String recvContactTel;

    /**
     * 客户收货国家
     */
    @ApiModelProperty("客户收货国家")
    private String recvCountry;

    /**
     * 客户收货省
     */
    @ApiModelProperty("客户收货省")
    private String recvProvince;

    /**
     * 客户收货市
     */
    @ApiModelProperty("客户收货市")
    private String recvCity;

    /**
     * 客户收货县
     */
    @ApiModelProperty("客户收货县")
    private String recvCounty;

    /**
     * 客户收货乡镇街道
     */
    @ApiModelProperty("客户收货乡镇街道")
    private String recvStreet;

    /**
     * 客户收货地址
     */
    @ApiModelProperty("客户收货地址")
    private String recvDetailaddr;

    /**
     * 指定收货日期
     */
    @ApiModelProperty("指定收货日期")
    private LocalDateTime demandDate;

    /**
     * 指定收货时间段
     */
    @ApiModelProperty("指定收货时间段")
    private LocalDateTime demandTimespan;

    /**
     * 物流单号
     */
    @ApiModelProperty("物流单号")
    private String logisDocNo;

    /**
     * 快递公司
     */
    @ApiModelProperty("快递公司")
    private String logisCarrierName;


    /**
     * 退货单明细
     */
    private List<SalSoItemReturnRespDTO> salSoItemReturnRespDTOS;
}
