package com.elitesland.order.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
@ApiModel(description = "零售结算单明细分页查询参数")
public class RetailOrderSettleDPagingParam extends AbstractOrderQueryParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id列表")
    private List<Long> ids;

    @ApiModelProperty("主表ID")
    private Long masId;

    @ApiModelProperty("主表ID列表")
    private List<Long> masIds;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("商品编号")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("批次号")
    private String lotNo;

    @ApiModelProperty("仓库ID")
    private Long whId;

    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
}
