package com.elitesland.order.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(description = "零售结算单分页查询参数")
public class RetailOrderSettlePagingParam extends AbstractOrderQueryParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id列表")
    private List<Long> ids;

    @ApiModelProperty("单据编号")
    private String docNo;

    @ApiModelProperty("记账月份-开始")
    private LocalDateTime finTimeFrom;

    @ApiModelProperty("记账月份-结束")
    private LocalDateTime finTimeTo;

    @ApiModelProperty("单据分类")
    private String docCls;

    @ApiModelProperty("对账状态")
    private String reconcileStatus;

    @ApiModelProperty("冲销状态")
    private String offsetStatus;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("仓库ID")
    private Long whId;

    @ApiModelProperty("零单结算单同步状态 RETAIL_SETTLE_SYNC_STATUS")
    private String syncStatus;

    @ApiModelProperty("创建日期-开始")
    private LocalDateTime createTimeFrom;

    @ApiModelProperty("创建日期-结束")
    private LocalDateTime createTimeTo;
}
