package com.elitesland.order.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.order.param
 * @date 2023/8/24 09:42
 */
@Data
public class SalDoDRpcDTO implements Serializable {


    @ApiModelProperty("记录唯一ID")
    private Long id;


    @ApiModelProperty("主表ID")
    private Long masId;


    @ApiModelProperty("行号")
    private BigDecimal lineNo;
    /**
     * 商品ID
     */
    @ApiModelProperty("商品ID")
    private Long itemId;
    /**
     * 商品规格
     */
    @ApiModelProperty("商品规格")
    private String itemSpec;
    /**
     * 实发数量-默认值0，库存模块回写
     */
    @ApiModelProperty("实发数量")
    private BigDecimal qty;


    @ApiModelProperty("批号")
    private String lotNo;

    @ApiModelProperty("首次批次号")
    private Long firstBatchNo;
    @ApiModelProperty("上游批次号")
    private Long  upstreamBatchNo;
    @ApiModelProperty("产品批号")
    private String productNo;

    @ApiModelProperty("出库单明细id")
    private Long odoDid;


    private Long relateDocId;

    private String relateDocNo;

    private Long relateDocDid;

    private String uom;


    @ApiModelProperty("来源发货单明细id,无论是否复制的行，都有")
    private Long sourceDocDId;

    @ApiModelProperty("库存状态")
    private String limit1;

}
