package com.elitesland.order.param;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 协同数据查询(SalDoD)查询退货收货单结果对象
 *
 * @author Dave
 * @since 2021-06-02 11:32:18
 */
@Data
@ApiModel(value = "SalDoDAndSoReturnRespDTO", description = "协同数据查询")
public class SalDoDAndSoReturnRespDTO implements Serializable {
    private static final long serialVersionUID = -5075799789239602730L;

    /**
     * 响应结果：
     *  收货单明细id,店铺名称,退货收货单号,退货收货单行号,退货收货单创建时间,商品,商品品牌,
     *  采购退货单,采购订单行号,销售退货单,退货单行号,退货时间,单位,
     *  采购退货单数量,已收数量,客户名称,客户手机,客户收货地址,平台订单编号,订单创建时间
     */

    /**
     * 退货收货单明细id
     */
    @ApiModelProperty("退货收货单明细id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 退货收货单ID
     */
    @ApiModelProperty("退货收货单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rdoId;

    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    @ApiModelProperty("是否一件代发")
    private String suppFlag;

    /**
     * 店铺id
     */
    @ApiModelProperty("店铺id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    /**
     * 店铺名称
     */
    @ApiModelProperty("店铺名称")
    private String buName;

    /**
     * 退货收货单编号
     */
    @ApiModelProperty("退货收货单编号")
    private String docNo;

    /**
     * 退货收货单行号
     */
    @ApiModelProperty("退货收货单行号")
    private BigDecimal lineNo;

    /**
     * 退货收货单创建时间
     */
    @ApiModelProperty("退货收货单创建时间")
    private LocalDateTime createTime;

    /**
     * 商品编号
     */
    @ApiModelProperty("商品编号")
    private String itemCode;

    /**
     * 商品名称
     */
    @ApiModelProperty("商品名称")
    private String itemName;

    /**
     * 商品品牌
     */
    @ApiModelProperty("商品品牌")
    private String itemBrand;

    /**
     * 采购退货单号
     */
    @ApiModelProperty(value = "采购退货单号")
    private String purDocNo;

    /**
     * 采购订单行号
     */
    @ApiModelProperty(value = "采购订单行号")
    private BigDecimal purDocLineno;

    /**
     * 销售退货单号
     */
    @ApiModelProperty(value = "销售退货单号")
    private String relateDocNo;

    /**
     * 退货单行号
     */
    @ApiModelProperty(value = "退货单行号")
    private BigDecimal relateDocLineno;

    /**
     * 退货时间
     */
    @ApiModelProperty(value = "退货时间")
    private LocalDateTime docTime;

    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String uom;

    /**
     * 采购退货单数量
     */
    @ApiModelProperty("采购退货单数量")
    private BigDecimal purReturnQty;

    /**
     * 已收数量
     */
    @ApiModelProperty("已收数量/实收数量")
    private BigDecimal qty;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String recvContactName;

    /**
     * 客户手机
     */
    @ApiModelProperty("客户手机")
    private String recvContactTel;

    /**
     * 客户收货国家
     */
    @ApiModelProperty("客户收货国家")
    private String recvCountry;

    /**
     * 客户收货省
     */
    @ApiModelProperty("客户收货省")
    private String recvProvince;

    /**
     * 客户收货市
     */
    @ApiModelProperty("客户收货市")
    private String recvCity;

    /**
     * 客户收货县
     */
    @ApiModelProperty("客户收货县")
    private String recvCounty;

    /**
     * 客户收货乡镇街道
     */
    @ApiModelProperty("客户收货乡镇街道")
    private String recvStreet;

    /**
     * 客户收货地址
     */
    @ApiModelProperty("客户收货地址")
    private String recvDetailaddr;

    /**
     * 平台订单编号
     */
    @ApiModelProperty("平台订单编号")
    private String relateDoc2No;

    /**
     * 平台订单创建时间
     */
    @ApiModelProperty("平台订单创建时间")
    private LocalDateTime createTimeOrder;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 退货方式
     */
    @ApiModelProperty("退货方式")
    @SysCode(sys = "yst-order", mod = "SO_RETURN_TYPE")
    private String returnType;
    @ApiModelProperty("退货方式 name")
    private String returnTypeName;
}
