package com.elitesland.order.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 销售发货和退货入库(SalDo)查询结果对象
 *
 * @author fred
 * @since 2021-05-14 11:32:18
 */

@Data
@ApiModel(value = "SalDoRespDTO", description = "销售发货和退货入库")
public class SalDoRespDTO implements Serializable {

    private static final long serialVersionUID = 6998365221225534314L;
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;

    /**
     * 发货单编号
     */
    @ApiModelProperty("发货单编号")
    private String docNo;
    /**
     * 发货单日期
     */
    @ApiModelProperty("发货单日期")
    private LocalDate docDate;
    /**
    * 发货时间
    */
    @ApiModelProperty("发货时间")
    private LocalDateTime docTime;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    private Long ouId;

    /**
     * 供应商id
     */
    @ApiModelProperty("供应商id")
    private Long suppId;

    @ApiModelProperty("客商ID")
    private Long enterpriseId;
    @ApiModelProperty("客商编码")
    private String enterpriseCode;
    @ApiModelProperty("客商名称")
    private String enterpriseName;
    @ApiModelProperty("客商类型")
    private String enterpriseType;

    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
     * 单据状态 [UDC]SAL:DO_STATUS
     */
    @ApiModelProperty("单据状态 [UDC]SAL:DO_STATUS")
    private String docStatus;
    /**
     * 单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("单据类别 [UDC]COM:DOC_CLS")
    private String docCls;
    /**
     * 是否供应商代发
     */
    @ApiModelProperty("是否供应商代发")
    private String suppFlag;
    /**
     * 单据类型 [UDC]SAL:DO_TYPE2
     */
    @ApiModelProperty("单据类型 [UDC]SAL:DO_TYPE2")
    private String docType2;
    /**
     * 关联单据ID So_ID，退货为退货订单
     */
    @ApiModelProperty("关联单据ID So_ID，退货为退货订单")
    private Long relateDocId;
    /**
     * 销售单号，退货为退货订单
     */
    @ApiModelProperty("销售单号，退货为退货订单")
    private String relateDocNo;
    /**
     * 关联单据ID So_ID，退货为原始订单
     */
    @ApiModelProperty("关联单据ID So_ID，退货为原始订单")
    private Long relateDoc2Id;
    /**
     * 销售单号，退货为原始订单
     */
    @ApiModelProperty("销售单号，退货为原始订单")
    private String relateDoc2No;
    /**
     * 接口状态 用于生成一件代发PO时
     */
    @ApiModelProperty("接口状态 用于生成一件代发PO时")
    private String intfStatus;
    /**
     * 接口时间 用于生成一件代发PO时
     */
    @ApiModelProperty("接口时间 用于生成一件代发PO时")
    private LocalDateTime intfTime;
    /**
     * 签收日期
     */
    @ApiModelProperty("签收日期")
    private LocalDateTime confirmTime;
    /**
     * 订单日期
     */
    @ApiModelProperty("订单日期")
    private LocalDateTime soTime;

    /**
     * 付款条款
     */
    @ApiModelProperty("付款条款")
    private String paymentTerm;

    /**
     * 发货单明细信息
     */
    @ApiModelProperty("发货单明细信息")
    private List<SalDoDRespDTO> salDoDRespDTOList;
}
