package com.elitesland.order.param;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;


@Data
@ApiModel(value = "SalSoDetailQueryDTO", description = "协同数据查询")
public class SalSoDetailQueryDTO extends AbstractExportQueryParam implements Serializable {
    private static final long serialVersionUID = -8251838243663705118L;
    /**
     * 销售单号
     */
    @ApiModelProperty("销售单号")
    private String docNo;
    private String docType;
    /**
     * 类型
     */
    @ApiModelProperty("类型")
    private String type;
    /**
     * 合同号
     */
    @ApiModelProperty("合同号")
    private String contractCode;
    /**
     * 合同号名称
     */
    @ApiModelProperty("合同名称")
    private String contractName;
    /**
     * 客户Id
     */
    @ApiModelProperty("客户Id")
    private Long custId;
    /**
     * 订单状态
     */
    @ApiModelProperty("订单状态")
    private String docStatus;
    /**
     * 销售公司编号
     */
    @ApiModelProperty("销售公司编号")
    private String ouCode;
    /**
     * 开票状态
     */
    @ApiModelProperty("开票状态")
    private String invStatus;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    /**
     * 销售订单明细id集合
     */
    @ApiModelProperty("销售订单明细id集合")
    private List<Long> soDIdList;

    /**
     * 公司id
     */
    @ApiModelProperty("公司id")
    private Long ouId;

}
