package com.elitesland.order.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class RetailOrderSettleSaveVO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty("单据编号")
    private String docNo;

    @ApiModelProperty("记账月份")
    private LocalDateTime finTime;

    @ApiModelProperty("单据分类")
    private String docCls;

    @ApiModelProperty("对账状态")
    private String reconcileStatus;

    @ApiModelProperty("冲销状态")
    private String offsetStatus;

    @ApiModelProperty("冲销单号")
    private String offsetDocNo;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司编号")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("客户主键")
    private Long custId;

    @ApiModelProperty("客户编号")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("仓库ID")
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("同步类型 NC")
    private String syncType;

    @ApiModelProperty("同步状态 0未同步 1同步成功")
    private String syncStatus;

    @ApiModelProperty("商品零售金额")
    private BigDecimal goodsRetailAmt;

    @ApiModelProperty("优惠金额")
    private BigDecimal discountAmt;

    @ApiModelProperty("商品成交金额")
    private BigDecimal goodsTransactionAmt;

    @ApiModelProperty("商品未税金额")
    private BigDecimal goodsUntaxedAmt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("运费")
    private BigDecimal freightAmt;

    @ApiModelProperty("其它费用")
    private BigDecimal otherExpenses;

    @ApiModelProperty("应收总额")
    private BigDecimal arAmt;

    @ApiModelProperty("实收总额")
    private BigDecimal realRecAmt;

    @ApiModelProperty("买家实付")
    private BigDecimal buyerActualPaymentAmt;

    @ApiModelProperty("平台补贴")
    private BigDecimal platformSubsidyAmt;

    @ApiModelProperty("调整金额")
    private BigDecimal adjustmentAmt;

    @ApiModelProperty("买家实付调整")
    private BigDecimal buyerPaymentAdjustmentAmt;

    @ApiModelProperty("平台补贴调整")
    private BigDecimal platformSubsidyAdjustmentAmt;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("明细")
    private List<RetailOrderSettleDSaveVO> details;
}
