package com.elitesland.order.service;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.order.Application;
import com.elitesland.order.param.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(name = Application.NAME, path = Application.PATH + SaleReconciliatRpcService.URI)
public interface SaleReconciliatRpcService {


    String URI = "/rpc/saleReconciliat";

//    数据传输接口  更新传输状态的接口  更新开票中的接口 更新开票完成接口
    /**
     * 查询对账列表
     * 状态state 已确认[CONFIRM]已审核[PASS]
     * invState 未开票[WINV]开票中[INVING]已开票[INVD]
     * @param
     * @return
     */
    @PostMapping("/querySalReconciliat")
    ApiResult<List<SaleReconciliatDTO>> querySalReconciliat(@RequestBody SalReconciliatQueryDTO salReconciliatQueryDTO);


    /**
     * 针对明细
     * 更新状态为传输状态为传输成功[TRANSED] / 未传输[NET_TRANS]
     */
    @PostMapping("/updateTransState")
    ApiResult<Long> updateTransState(@RequestBody SalReconciliatQueryDTO salReconciliatQueryDTO);


    /**
     * 针对主表
     * 更新开票状态为开票中[ING] 的接口
     * 更新开票申请单号
     */
    @PostMapping("/updateInvingState")
    ApiResult<Long> updateInvingState(@RequestBody List<SalReconciliatInvDTO> salReconciliatInvDTO);


    /**
     *
     * 针对主表(开票成功/开票失败)
     * 更新开票状态为已开票[SUCCESS]、[FAIL]的接口
     */
    @PostMapping("/updateInvedState")
    ApiResult<Long> updateInvedState(SaleReconciliatDTO salReconciliatDTO);


    /**
     * 更新销售对账单状态
     * @param paramDTO
     * @return
     */
    @PostMapping("/updateStateByParam")
    ApiResult<Long> updateStateByParam(@RequestBody SaleReconciliatParamDTO paramDTO);

}
