package com.elitesland.order.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 退货收货单(SalDoDO)保存参数(团内退货&旧件返还业务)明细
 *
 * @author dave
 * @since 2022-02-22
 */

@Data
@ApiModel(value = "SalDoReturnDetailSaveDTO", description = "退货收货单保存参数(团内退货&旧件返还业务)明细")
public class SalDoReturnDetailSaveDTO implements Serializable {
    private static final long serialVersionUID = -6948164700151819245L;

    /**
     * 采购退货登记单明细行号
     */
    @ApiModelProperty("采购退货登记单明细行号")
    private BigDecimal relateDoc3Lineno;

    /**
     * 采购退货登记单明细id
     */
    @ApiModelProperty("采购退货登记单明细id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc3Did;

    /**
     * 采购退货订单明细行号
     */
    @ApiModelProperty("采购退货订单明细行号")
    private BigDecimal rootDocLineno;

    /**
     * 采购退货订单明细id
     */
    @ApiModelProperty("采购退货订单明细id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootDocDid;

    /**
     * 商品id
     */
    @ApiModelProperty("商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    /**
     * 商品单位
     */
    @ApiModelProperty("商品单位")
    private String uom;

    /**
     * 操作数量
     */
    @ApiModelProperty("操作数量")
    private BigDecimal qty;

    /**
     * 工单单号(对应 pur_gr_d 的relate_doc2_no )
     */
    @ApiModelProperty("工单单号")
    private String gdCode;

}