package com.elitesland.order.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Author: ryan.xu
 * @since 2023/9/8
 */
@Data
public class SalSoAllocRespDTO implements Serializable {
    private static final long serialVersionUID = 2278771265958284189L;
    @ApiModelProperty("记录唯一ID")
    private Long id;
    @ApiModelProperty("主表ID SAL_SO.ID")
    private Long masId;
    @ApiModelProperty("销售订单明细ID")
    private Long soDId;
    @ApiModelProperty("商品ID")
    private Long itemId;
    @ApiModelProperty("配货时间")
    private LocalDateTime allocTime;
    @ApiModelProperty("已配货数量")
    private BigDecimal allocQty;
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    private String relateDoc2Cls;
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    @ApiModelProperty("关联单据2明细ID")
    private Long relateDoc2Did;
    @ApiModelProperty("关联单据2行号")
    private BigDecimal relateDoc2Lineno;
    @ApiModelProperty("公司ID")
    private Long ouId;
    @ApiModelProperty("收货仓库ID")
    private Long whId;
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;
}
