package com.elitesland.order.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 生成采购订单返回值
 *
 * @author fred
 * @since 2021-07-09 09:27:26
 */

@Data
@ApiModel(value = "SalSoAllocPurPoRespDTO", description = "生成采购订单返回值")
public class SalSoAllocPurPoRespDTO implements Serializable {

    private static final long serialVersionUID = 5630983627134732006L;
    /**
    * 记录唯一ID
    */    
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
    * 主表ID SAL_SO.ID
    */    
    @ApiModelProperty("主表ID SAL_SO.ID")
    private Long masId;
    /**
     * 销售订单明细ID
     */
    @ApiModelProperty("销售订单明细ID")
    private Long soDId;
    /**
     * 商品ID
     */
    @ApiModelProperty("商品ID")
    private Long itemId;

    /**
     * 配货时间
     */
    @ApiModelProperty("配货时间")
    private LocalDateTime allocTime;

    /**
     * 已配货数量
     */
    @ApiModelProperty("已配货数量")
    private BigDecimal allocQty;

    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    private String relateDoc2Cls;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID
     */
    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;
    /**
     * 关联单据2编号
     */
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    /**
     * 关联单据2明细ID
     */
    @ApiModelProperty("关联单据2明细ID")
    private Long relateDoc2Did;
    /**
     * 关联单据2行号
     */
    @ApiModelProperty("关联单据2行号")
    private BigDecimal relateDoc2Lineno;


}