package com.elitesland.order.param;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class SalDoItemReturnParamDTO implements Serializable {


    private static final long serialVersionUID = 4352005787666051234L;
    /**
     * 退货商品明细id
     */
    @ApiModelProperty("退货商品明细id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 退货单主表id
     */
    @ApiModelProperty("退货单主表id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    /**
     * 商品名称
     */
    @ApiModelProperty("商品名称")
    private String itemName;
    /**
     * 商品编号
     */
    @ApiModelProperty("商品编号")
    private String itemCode;

    /**
     * 商品品牌
     */
    @ApiModelProperty("商品品牌")
    private String itemBrand;

    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String uom;

    /**
     * 1、RSOD(退货订单明细)：申请退货数量->=0。默认=可退数量，能手输，不能大于可退数量（发货10，已退3，则申请退货默认7，不能>7）。
     * 2、RDOD(退货收货单明细)：实收退货数量-默认值DEMAND_QTY，可手改(大于零/小于等于DEMAND_QTY)
     */
    @ApiModelProperty("RSOD申请退货数量/RDOD实收退货数量/退货数量")
    private BigDecimal qty;

    /**
     * 已发货数量
     */
    @ApiModelProperty("已发货数量")
    private BigDecimal shippedQty;

    /**
     * 退货数量
     */
    @ApiModelProperty("退货数量")
    private BigDecimal returnedQty;

    /**
     * RSOD(退货订单明细)：实限退货数量-默认为0，由退货收货单回写。不能改
     */
    @ApiModelProperty("实际退货数量/已收数量")
    private BigDecimal confirmQty;

    /**
     * 临时实收退货数量等同confirmQty
     */
    @ApiModelProperty("临时实收退货数量等同confirmQty")
    private BigDecimal tempQty;

    /**
     * RDOD(退货收货单明细)：申请退货数量-RSOD(退货订单明细)的QTY(申请退货数量) - CONFIRM_QTY(实限退货数量)
     */
    @ApiModelProperty("申请退货数量")
    private BigDecimal demandQty;

    /**
     * 下推数量
     */
    @ApiModelProperty("下推数量")
    private BigDecimal pushedQty;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    @ApiModelProperty("供应商名称")
    private String suppName;

    /**
     * 商品ID
     */
    @ApiModelProperty("商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    /**
     * 商品规格
     */
    @ApiModelProperty("商品规格")
    private String itemSpec;

    /**
     * 条码
     */
    @ApiModelProperty("条码")
    private String barcode;

    /**
     * 批次号
     */
    @ApiModelProperty("批次号")
    private String lotNo;

    /**
     * 是否启用批次号
     */
    @ApiModelProperty("是否启用批次号")
    private Boolean lotFlag;

    /**
     * 毛重
     */
    @ApiModelProperty("毛重")
    private BigDecimal grossWeight;

    /**
     * 单个毛重
     */
    @ApiModelProperty("单个毛重")
    private BigDecimal singleGrossWeight;

    /**
     * 净重
     */
    @ApiModelProperty("净重")
    private BigDecimal netWeight;

    /**
     * 单个净重
     */
    @ApiModelProperty("单个净重")
    private BigDecimal singleNetWeight;

    /**
     * 体积
     */
    @ApiModelProperty("体积")
    private BigDecimal volume;

    /**
     * 单个体积
     */
    @ApiModelProperty("单个体积")
    private BigDecimal singleVolume;

    /**
     * 关联单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("RSO关联单据类别 [UDC]COM:DOC_CLS")
    private String relateDocCls;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("RSO关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @ApiModelProperty("RSO关联单据ID")
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("RSO关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据明细ID
     */
    @ApiModelProperty("RSO关联单据明细ID")
    private Long relateDocDid;
    /**
     * 关联单据行号
     */
    @ApiModelProperty("RSO关联单据行号")
    private BigDecimal relateDocLineno;
    /**
     * 行号
     */
    @ApiModelProperty("行号")
    private BigDecimal lineNo;

    /**
     * 退货订单行状态
     */
    @ApiModelProperty("退货订单行状态")
    private String lineStatus;

    /**
     * 行类型
     */
    @ApiModelProperty("行类型")
    private String lineType;

    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    private Long whId;
    /**
     * 仓库编码
     */
    @ApiModelProperty("仓库编码")
    private String whCode;
    /**
     * 仓库名称
     */
    @ApiModelProperty("仓库名称")
    private String whName;

    /**
     * 功能区
     */
    @ApiModelProperty("功能区")
    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    private String deter2;
    private String deter2Name;

    /**
     * 体积单位
     */
    @ApiModelProperty("体积单位")
    private String volumeUom;

    /**
     * 重量单位
     */
    @ApiModelProperty("重量单位")
    private String weightUom;

    /**
     * 关联单据3类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("SO关联单据3类别 [UDC]COM:DOC_CLS")
    private String relateDoc3Cls;
    /**
     * 关联单据3类型
     */
    @ApiModelProperty("SO关联单据3类型")
    private String relateDoc3Type;
    /**
     * 关联单据3ID
     */
    @ApiModelProperty("SO关联单据3ID")
    private Long relateDoc3Id;
    /**
     * 关联单据3编号
     */
    @ApiModelProperty("SO关联单据3编号")
    private String relateDoc3No;
    /**
     * 关联单据3明细ID
     */
    @ApiModelProperty("SO关联单据3明细ID")
    private Long relateDoc3Did;
    /**
     * 关联单据3行号
     */
    @ApiModelProperty("SO关联单据3行号")
    private BigDecimal relateDoc3Lineno;

    /**
     * 关联单据
     */
    @ApiModelProperty("SO关联单据")
    private String rootDocCls;
    /**
     * 关联单据
     */
    @ApiModelProperty("SO关联单据")
    private String rootDocType;
    /**
     * 关联单据
     */
    @ApiModelProperty("SO关联单据")
    private Long rootDocId;
    /**
     * 关联单据
     */
    @ApiModelProperty("SO关联单据")
    private String rootDocNo;
    /**
     * 关联单据
     */
    @ApiModelProperty("SO关联单据")
    private Long rootDocDId;
    /**
     * 关联单据
     */
    @ApiModelProperty("SO关联单据")
    private Long rootDocLineno;

    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;

    @ApiModelProperty("过期日期")
    private LocalDateTime expireDate;

    @ApiModelProperty("保质期天数")
    private Integer expireDays;

    @ApiModelProperty("新鲜度")
    private String fressType;

    private String es1;

    private String es2;

    private String es3;

    private String es4;

    private String es5;

    private String es6;

    @ApiModelProperty("含税金额")
    private BigDecimal amt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("未税金额")
    private BigDecimal netAmt;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("未税单价")
    private BigDecimal netPrice;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("拆分前成交总金额")
    private BigDecimal sourceAmt;

    @ApiModelProperty("折前的含税单价")
    private BigDecimal prePrice;

    @ApiModelProperty("优惠前无税单价")
    private BigDecimal preNetPrice;

    @ApiModelProperty("折扣金额")
    private BigDecimal discountAmt;

    @ApiModelProperty("优惠前含税金额")
    private BigDecimal preAmt;


    @ApiModelProperty("流水ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ioId;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("库存状态")
    private String limit1;

}
