package com.elitesland.order.param;

import lombok.Data;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import io.swagger.annotations.ApiModel;



/**
 * @author : WWW
 * @date : 2023-9-11
 * @desc : 销售对账明细表
 */

@Data
@ApiModel(description = "销售对账明细表")
public class SaleReconciliatDtlDTO implements Serializable {


    /**
     * 主键id
     */
    @ApiModelProperty("主键id")
    private Long id;

    /**
     * 签收日期
     */
    @ApiModelProperty("签收日期")
    private LocalDateTime confirmTime;

    /**
     * 发/收货单号
     */
    @ApiModelProperty("发/收货单号")
    private String docNo;

    /**
     * 发/收货行号
     */
    @ApiModelProperty("发/收货行号")
    private String lineNo;

    /**
     * 发货日期
     */
    @ApiModelProperty("发货日期")
    private LocalDateTime shipTime;

    /**
     * 销/退订单号
     */
    @ApiModelProperty("销/退订单号")
    private String logisDocNo;

    /**
     * 订单类型
     */
    @ApiModelProperty("订单类型")
    private String relateDocType;

    /**
     * 订单行号
     */
    @ApiModelProperty("订单行号")
    private String relateDocLineno;

    /**
     * 商品id
     */
    @ApiModelProperty("商品id")
    private Long itemId;

    /**
     * 商品编码
     */
    @ApiModelProperty("商品编码")
    private String itemCode;

    /**
     * 商品名称
     */
    @ApiModelProperty("商品名称")
    private String itemName;

    /**
     * 商品规格
     */
    @ApiModelProperty("商品规格")
    private String itemSpec;

    /**
     * 税收分类编码
     */
    @ApiModelProperty("税收分类编码")
    private String taxCategoryCode;

    /**
     * 签收数量
     */
    @ApiModelProperty("签收数量")
    private BigDecimal confirmQty;

    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String uom;

    /**
     * 数量单位
     */
    @ApiModelProperty("数量单位")
    private String qtyUom;

    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    /**
     * 签收含税金额
     */
    @ApiModelProperty("签收含税金额")
    private BigDecimal includTaxAmt;

    /**
     * 签收不含税金额
     */
    @ApiModelProperty("签收不含税金额")
    private BigDecimal excludTaxAmt;

    /**
     * 签收税额
     */
    @ApiModelProperty("签收税额")
    private BigDecimal taxAmt;

    /**
     * 仓库id
     */
    @ApiModelProperty("仓库id")
    private Long whId;

    /**
     * 仓库编码
     */
    @ApiModelProperty("仓库编码")
    private String whCode;

    /**
     * 仓库名称
     */
    @ApiModelProperty("仓库名称")
    private String whName;

    /**
     * 关联id
     */
    @ApiModelProperty("关联id")
    private Long masId;

    /**
     * 发货/收货单明细id
     */
    @ApiModelProperty("发货/收货单明细id")
    private Long relateDocDid;

    /**
     * 销/退订单号
     */
    @ApiModelProperty("销/退订单号")
    private String relateDocNo;

    /**
     * 未对账数量
     */
    @ApiModelProperty("未对账数量")
    private BigDecimal noSoaQty;

    /**
     * 本次对账数量
     */
    @ApiModelProperty("本次对账数量")
    private BigDecimal soaQty;

    /**
     * 对账含税金额
     */
    @ApiModelProperty("对账含税金额")
    private BigDecimal soaAmt;

    /**
     * 对账未税金额
     */
    @ApiModelProperty("对账未税金额")
    private BigDecimal soaNetAmt;

    /**
     * 对账税额
     */
    @ApiModelProperty("对账税额")
    private BigDecimal soaTaxAmt;

    /**
     * 发票折扣率
     */
    @ApiModelProperty("发票折扣率")
    private BigDecimal invDiscount;

    /**
     * 票扣含税金额
     */
    @ApiModelProperty("票扣含税金额")
    private BigDecimal invDiscountAmt;

    /**
     * 票扣未税金额
     */
    @ApiModelProperty("票扣未税金额")
    private BigDecimal invDiscountNetAmt;

    /**
     * 可开票含税金额
     */
    @ApiModelProperty("可开票含税金额")
    private BigDecimal invAmt;

    /**
     * 可开票未税金额
     */
    @ApiModelProperty("可开票未税金额")
    private BigDecimal invNetAmt;

    /**
     * 可开票税额
     */
    @ApiModelProperty("可开票税额")
    private BigDecimal invTaxAmt;

    /**
     * 返利冲抵金额
     */
    @ApiModelProperty("返利冲抵金额")
    private BigDecimal flDeductionAmt;

    /**
     * 辅单位
     */
    @ApiModelProperty("辅单位")
    private String auxUom;

    /**
     * 订单日期
     */
    @ApiModelProperty("订单日期")
    private LocalDateTime soDate;

    /**
     * 下单渠道
     */
    @ApiModelProperty("下单渠道")
    private String soSource;

    /**
     * 本次对账辅数量
     */
    @ApiModelProperty("本次对账辅数量")
    private BigDecimal auxSoaQty;

    /**
     * 是否赠品
     */
    @ApiModelProperty("是否赠品")
    private String giftsFlag;

    /**
     * 折扣后辅无税单价
     */
    @ApiModelProperty("折扣后辅无税单价")
    private BigDecimal discountAuxNetPrice;

    /**
     * 折扣后辅含税单价
     */
    @ApiModelProperty("折扣后辅含税单价")
    private BigDecimal discountAuxPrice;

    /**
     * 折扣后主无税单价
     */
    @ApiModelProperty("折扣后主无税单价")
    private BigDecimal discountNetPrice;

    /**
     * 折扣后主含税单价
     */
    @ApiModelProperty("折扣后主含税单价")
    private BigDecimal discountPrice;

    /**
     * 原辅无税单价
     */
    @ApiModelProperty("原辅无税单价")
    private BigDecimal auxNetPrice;

    /**
     * 原辅含税单价
     */
    @ApiModelProperty("原辅含税单价")
    private BigDecimal auxPrice;

    /**
     * 原主无税单价
     */
    @ApiModelProperty("原主无税单价")
    private BigDecimal mainNetPrice;

    /**
     * 原主含税单价
     */
    @ApiModelProperty("原主含税单价")
    private BigDecimal mainPrice;

    /**
     * 单品折扣(%)
     */
    @ApiModelProperty("单品折扣(%)")
    private BigDecimal discRatio;

    /**
     * 传输状态
     */
    @ApiModelProperty("传输状态")
    private String transState;

    /**
     * 原含税金额
     */
    @ApiModelProperty("原含税金额")
    private BigDecimal oAmt;

    /**
     * 原未税金额
     */
    @ApiModelProperty("原未税金额")
    private BigDecimal oNetAmt;

    /**
     * 原税额
     */
    @ApiModelProperty("原税额")
    private BigDecimal oTaxAmt;


    /**
     * 客户id
     */
    @ApiModelProperty("客户id")
    private Long custId;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    private String custCode;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String custName;

    /**
     * 业务员员工名字
     */
    @ApiModelProperty("业务员员工名字")
    private String agentName;

    /**
     * 业务员员工ID
     */
    @ApiModelProperty("业务员员工ID")
    private Long agentEmpId;

    /**
     * 收货联系人
     */
    @ApiModelProperty("收货联系人")
    private String recvContactName;

    /**
     * 收货联系电话
     */
    @ApiModelProperty("收货联系电话")
    private String recvContactTel;

    /**
     * 收货详细地址
     */
    @ApiModelProperty("收货详细地址")
    private String recvDetailaddr;

    @ApiModelProperty("根单据类别 来源采购订单等。[UDC]COM:DOC_CLS")
    private String rootDocCls;

    @ApiModelProperty("根单据类型")
    private String rootDocType;

    @ApiModelProperty("根单据ID")
    private Long rootDocId;

    @ApiModelProperty("根单据编号")
    private String rootDocNo;

    @ApiModelProperty("根单据下单时间")
    private LocalDateTime rootDocTime;

    @ApiModelProperty("根单据明细id")
    private Long rootDocDId;

    @ApiModelProperty("发票编号")
    private String invoiceNo;
}

